/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zotmc.tomahawk.CommonProxy;
import zotmc.tomahawk.DamageFaker;
import zotmc.tomahawk.DispenserHandler;
import zotmc.tomahawk.OnlySilverHandler;
import zotmc.tomahawk.PositionTracker;
import zotmc.tomahawk.TomahawkRegistry;
import zotmc.tomahawk.config.Config;
import zotmc.tomahawk.projectile.EntityTomahawk;
import zotmc.tomahawk.projectile.PlayerTomahawk;
import zotmc.tomahawk.util.Holder;

@Mod(modid="axetomahawk", name="Tomahawk", version="1.3.0.0-1.7.2", guiFactory="zotmc.tomahawk.config.GuiConfigs")
public class Tomahawk {
    public static final String MODID = "axetomahawk";
    public static final String NAME = "Tomahawk";
    public static final String PACKAGE_NAME = "zotmc.tomahawk";
    public static final String GUI_FACTORY = "zotmc.tomahawk.config.GuiConfigs";
    @SidedProxy(clientSide="zotmc.tomahawk.ClientProxy", serverSide="zotmc.tomahawk.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="axetomahawk")
    public static Tomahawk axetomahawk;
    public final Logger log = LogManager.getFormatterLogger((String)"axetomahawk");
    public DamageFaker damageFaker;
    private final Holder<Config.ConfigState> configState = Holder.absent();
    private Random rand = new Random();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.init(new Configuration(event.getSuggestedConfigurationFile()), this.configState);
        EntityRegistry.registerModEntity(EntityTomahawk.class, (String)"tomahawk", (int)0, (Object)this, (int)64, (int)18, (boolean)true);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerRenderer();
        DispenserHandler.init();
        boolean fakeDamage = false;
        if (Loader.isModLoaded((String)"AdditionalEnchantments")) {
            fakeDamage = true;
        }
        if (Loader.isModLoaded((String)"MoreEnchants")) {
            TomahawkRegistry.registerDamageFaking(FMLCommonHandler.instance().findContainerFor((Object)"MoreEnchants"));
            fakeDamage = true;
        }
        if (fakeDamage) {
            this.damageFaker = new DamageFaker();
            MinecraftForge.EVENT_BUS.register((Object)this.damageFaker);
        }
        if (Loader.isModLoaded((String)"onlysilver")) {
            OnlySilverHandler.init();
        }
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                final Class<?> hatchet = Class.forName("tconstruct.items.tools.Hatchet");
                TomahawkRegistry.registerThrowableAxes(new Predicate<Item>(){

                    public boolean apply(Item input) {
                        return (Boolean)Config.current().tiCHatchetsThrowing.get() != false && hatchet.isInstance(input);
                    }
                });
                final Class<?> fryingPan = Class.forName("tconstruct.items.tools.FryingPan");
                TomahawkRegistry.registerThrowableAxes(new Predicate<Item>(){

                    public boolean apply(Item input) {
                        return (Boolean)Config.current().tiCFryingPansThrowing.get() != false && fryingPan.isInstance(input);
                    }
                });
                TomahawkRegistry.registerHitSounds(new Function<Item, Block.SoundType>(){
                    final Random rand = new Random();
                    final Block.SoundType sound = new Block.SoundType("tinker:frypan_hit", 1.0f, 1.0f){

                        public float func_150494_d() {
                            return (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f;
                        }
                    };

                    public Block.SoundType apply(Item input) {
                        return fryingPan.isInstance(input) ? this.sound : null;
                    }
                });
            }
            catch (Throwable e) {
                this.log.catching(e);
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.damageFaker != null) {
            if (Loader.isModLoaded((String)"AdditionalEnchantments")) {
                try {
                    this.damageFaker.register(Class.forName("ak.AdditionalEnchantments.VorpalEventHook").getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable e) {
                    this.log.catching(e);
                }
            }
            if (Loader.isModLoaded((String)"MoreEnchants")) {
                for (Enchantment ench : Enchantment.field_77331_b) {
                    if (ench == null || !ench.getClass().getName().equals("com.demoxin.minecraft.moreenchants.Enchantment_Vorpal")) continue;
                    this.damageFaker.register(ench);
                }
            }
        }
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartedEvent event) {
        this.configState.set(Config.ConfigState.AVAILABLE);
        TomahawkRegistry.refreshThrowableAxes();
        TomahawkRegistry.refreshHitSounds();
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item;
        if ((event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && (item = event.entityPlayer.func_70694_bm()) != null && TomahawkRegistry.isThrowableAxe(item.func_77973_b())) {
            EntityPlayer player = event.entityPlayer;
            World world = player.field_70170_p;
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                boolean useBlock;
                int x = event.x;
                int y = event.y;
                int z = event.z;
                Block block = world.func_147439_a(x, y, z);
                boolean bl = useBlock = !player.func_70093_af();
                if (!useBlock) {
                    useBlock = player.func_70694_bm().func_77973_b().doesSneakBypassUse(world, x, y, z, player);
                }
                if (useBlock && event.useBlock != Event.Result.DENY && block.func_149727_a(world, x, y, z, player, event.face, 0.5f, 0.5f, 0.5f)) {
                    event.useBlock = Event.Result.DENY;
                    return;
                }
            }
            boolean isCreative = player.field_71075_bZ.field_75098_d;
            this.throwTomahawk((EntityLivingBase)player, player.func_70694_bm(), world, true, isCreative ? EntityTomahawk.PickUpType.CREATIVE : EntityTomahawk.PickUpType.SURVIVAL);
            if (!isCreative) {
                player.func_70062_b(0, null);
            }
            event.useItem = Event.Result.DENY;
            event.useBlock = Event.Result.DENY;
        }
    }

    public void throwTomahawk(EntityLivingBase thrower, ItemStack tomahawk, World world, boolean isForwardSpin, EntityTomahawk.PickUpType pickUpType) {
        EntityTomahawk hawk = new EntityTomahawk(world, thrower, tomahawk);
        hawk.setIsForwardSpin(isForwardSpin);
        hawk.pickUpType = pickUpType;
        thrower.func_70031_b(false);
        thrower.func_71038_i();
        if (thrower instanceof EntityPlayer) {
            ((EntityPlayer)thrower).func_71020_j(0.3f);
            if (world.field_72995_K) {
                // empty if block
            }
        }
        world.func_72956_a((Entity)thrower, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 1.2f) + 0.5f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)hawk);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Entity sod;
        if (!event.entityLiving.field_70170_p.field_72995_K && ((sod = event.source.func_76364_f()) instanceof EntityTomahawk || sod instanceof PlayerTomahawk) && sod.func_70027_ad()) {
            event.entityLiving.func_70015_d(5);
        }
    }

    @SubscribeEvent
    public void onEntityConstruct(EntityEvent.EntityConstructing event) {
        if (event.entity.field_70170_p != null && !event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            new PositionTracker((EntityPlayer)event.entity).register();
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            PositionTracker.get((EntityPlayer)event.entity).onUpdate();
        }
    }
}

