/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.ModContainer;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import zotmc.tomahawk.config.Config;
import zotmc.tomahawk.util.Utils;

public class TomahawkRegistry {
    private static final Queue<Predicate<Item>> throwableAxes = Queues.newArrayDeque();
    private static final Set<Item> throwableAxesCache = Sets.newIdentityHashSet();
    private static final Queue<Function<Item, Block.SoundType>> hitSounds = Queues.newArrayDeque();
    private static final Map<Item, Block.SoundType> hitSoundsCache = Maps.newIdentityHashMap();
    private static final Set<ModContainer> damageFakings = Sets.newIdentityHashSet();

    public static void registerThrowableAxes(Predicate<Item> isThrowableAxe) {
        throwableAxes.add(isThrowableAxe);
    }

    public static void registerHitSounds(Function<Item, Block.SoundType> hitSoundFactory) {
        hitSounds.add(hitSoundFactory);
    }

    public static void registerDamageFaking(ModContainer mc) {
        damageFakings.add(mc);
    }

    public static boolean isThrowableAxe(Item item) {
        return throwableAxesCache.contains(item);
    }

    public static boolean isThrowableAxe(ItemStack item) {
        return item != null && TomahawkRegistry.isThrowableAxe(item.func_77973_b());
    }

    public static Predicate<Item> isThrowableAxeRaw() {
        return Predicates.or(throwableAxes);
    }

    public static Block.SoundType getHitSound(Item axe) {
        return hitSoundsCache.get(axe);
    }

    public static boolean fakeDamages(ModContainer modContainer) {
        return damageFakings.contains(modContainer);
    }

    public static void refreshThrowableAxes() {
        throwableAxesCache.clear();
        Predicate predicates = Predicates.or(throwableAxes);
        for (Item i : Utils.itemList()) {
            if (Config.current().axeBlacklist.items().get().contains(i) || !predicates.apply((Object)i)) continue;
            throwableAxesCache.add(i);
        }
    }

    public static void refreshHitSounds() {
        hitSoundsCache.clear();
        block0: for (Item i : Utils.itemList()) {
            for (Function function : hitSounds) {
                Block.SoundType s = (Block.SoundType)function.apply((Object)i);
                if (s == null) continue;
                hitSoundsCache.put(i, s);
                continue block0;
            }
        }
    }

    static {
        TomahawkRegistry.registerThrowableAxes(new Predicate<Item>(){

            public boolean apply(Item input) {
                return (Boolean)Config.current().commonAxesThrowing.get() != false && input instanceof ItemAxe;
            }
        });
    }
}

