/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import zotmc.tomahawk.config.Configurable;
import zotmc.tomahawk.config.ConfigurableStringList;
import zotmc.tomahawk.util.TransformedSet;
import zotmc.tomahawk.util.Utils;

public class ConfigurableItemIdSet
extends ConfigurableStringList<Set<String>, String> {
    private ItemSet items;

    ConfigurableItemIdSet(String category, String key) {
        super(category, key);
    }

    @Override
    protected Set<String> getInitialValue() {
        return ImmutableSet.of();
    }

    @Override
    protected Function<String, String> toStringFunction() {
        return Functions.identity();
    }

    @Override
    protected Function<String, String> valueOfFunction() {
        return Functions.identity();
    }

    @Override
    protected void setIterable(FluentIterable<String> iterable) {
        this.value = iterable.toSet();
    }

    public ItemSet items() {
        return this.items != null ? this.items : (this.items = new ItemSet());
    }

    public class ItemSet
    extends Configurable<Set<Item>> {
        private final Function<Item, String> toString;
        private final Function<String, Item> valueOf;
        private Set<Item> value;

        private ItemSet() {
            super("", "");
            this.toString = new Function<Item, String>(){

                public String apply(Item input) {
                    return Utils.getItemRegistry().func_148750_c((Object)input);
                }
            };
            this.valueOf = new Function<String, Item>(){

                public Item apply(String input) {
                    return (Item)Utils.getItemRegistry().getRaw(input);
                }
            };
            this.value = Sets.filter((Set)new TransformedSet<String, Item>(){

                @Override
                protected Set<String> backing() {
                    return (Set)ConfigurableItemIdSet.this.value;
                }

                @Override
                protected Function<String, Item> transformation() {
                    return ItemSet.this.valueOf;
                }

                @Override
                public boolean contains(Object o) {
                    return o instanceof Item && this.backing().contains(ItemSet.this.toString.apply((Object)((Item)o)));
                }

                @Override
                public boolean add(Item e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }
            }, (Predicate)Predicates.notNull());
        }

        public Set<Item> get() {
            return this.value;
        }

        @Override
        Configurable<Set<Item>> set(Set<Item> value) {
            ConfigurableItemIdSet.this.set(ImmutableSet.builder().addAll((Iterable)Collections2.transform(value, this.toString)).addAll((Iterable)Sets.filter((Set)((Set)ConfigurableItemIdSet.this.value), (Predicate)Predicates.compose((Predicate)Predicates.isNull(), this.valueOf))).build());
            return this;
        }

        @Override
        @Deprecated
        void load(Configuration configFile) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        void save(Configuration configFile) {
            throw new UnsupportedOperationException();
        }
    }
}

