/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import zotmc.tomahawk.config.Config;
import zotmc.tomahawk.config.Configurable;
import zotmc.tomahawk.config.GuiConfigs;
import zotmc.tomahawk.config.GuiEdit;
import zotmc.tomahawk.config.GuiItemButton;
import zotmc.tomahawk.config.GuiPropCat;
import zotmc.tomahawk.util.Holder;
import zotmc.tomahawk.util.PseudoIterator;
import zotmc.tomahawk.util.Utils;

@SideOnly(value=Side.CLIENT)
public class GuiEditItemSet
extends GuiEdit {
    private static final int SLOT_SIZE = 26;
    private final Configurable<Set<Item>> value;
    private final Iterable<Item> universe;
    private final boolean negate;
    private final Set<Item> mutable;
    private final Holder<ItemStack> toolTipItem = Holder.absent();
    private List<Category> categories;
    private EmbededList list;

    public GuiEditItemSet(GuiScreen parent, Config config, Configurable<Set<Item>> value, Iterable<Item> universe, boolean negate) {
        super(parent, config);
        this.value = value;
        this.universe = universe;
        this.negate = negate;
        this.mutable = Sets.newIdentityHashSet();
        this.mutable.addAll((Collection)value.get());
    }

    @Override
    protected void quit() {
        this.value.set((Set<Item>)ImmutableSet.copyOf(this.mutable));
        super.quit();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        LinkedHashMultimap classified = LinkedHashMultimap.create();
        for (Item item : this.universe) {
            classified.put((Object)Utils.getModid(item), (Object)item);
        }
        this.categories = Lists.newLinkedList();
        for (Map.Entry entry : classified.asMap().entrySet()) {
            this.categories.add(new Category((String)entry.getKey(), (List<Item>)ImmutableList.copyOf((Collection)((Collection)entry.getValue()))));
        }
        this.list = new EmbededList();
    }

    @Override
    public void drawEmbeded(int mouseX, int mouseY, float tickFrac) {
        super.drawEmbeded(mouseX, mouseY, tickFrac);
        this.list.func_148128_a(mouseX, mouseY, tickFrac);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float tickFrac) {
        this.toolTipItem.clear();
        super.func_73863_a(mouseX, mouseY, tickFrac);
        if (this.toolTipItem.isPresent()) {
            this.func_146285_a(this.toolTipItem.get(), mouseX, mouseY);
        }
    }

    protected void func_73864_a(int x, int y, int mouseEvent) {
        if (!this.list.func_148179_a(x, y, mouseEvent)) {
            super.func_73864_a(x, y, mouseEvent);
        }
    }

    protected void func_146286_b(int x, int y, int mouseEvent) {
        if (!this.list.func_148181_b(x, y, mouseEvent)) {
            super.func_146286_b(x, y, mouseEvent);
        }
    }

    public int itemsPerRow() {
        return Math.max(1, (this.field_146294_l - 126) / 26);
    }

    private class ItemEntry
    implements GuiListExtended.IGuiListEntry {
        private final List<GuiItemButton> itemButtons;

        public ItemEntry(List<Item> items) {
            this.itemButtons = FluentIterable.from(items).transform((Function)new Function<Item, GuiItemButton>(){

                public GuiItemButton apply(Item input) {
                    return new GuiItemButton(ItemEntry.this.toggleState(input)).setDisplayItem(input).setDisplayState(ItemEntry.this.getState(input)).setToolTipItem(GuiEditItemSet.this.toolTipItem);
                }
            }).toList();
        }

        public Runnable toggleState(final Item item) {
            return new Runnable(){

                @Override
                public void run() {
                    if (!GuiEditItemSet.this.mutable.add(item)) {
                        GuiEditItemSet.this.mutable.remove(item);
                    }
                }
            };
        }

        public Supplier<Boolean> getState(final Item item) {
            return new Supplier<Boolean>(){

                public Boolean get() {
                    return GuiEditItemSet.this.negate ^ GuiEditItemSet.this.mutable.contains(item);
                }
            };
        }

        public void func_148279_a(int index, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            int n = this.itemButtons.size();
            x = listWidth / 2 - n * 26 / 2;
            for (int i = 0; i < n; ++i) {
                this.drawSlot(i, x, y, mouseX, mouseY);
                x += 26;
            }
        }

        public void drawSlot(int index, int x, int y, int mouseX, int mouseY) {
            this.itemButtons.get(index).setLeftTop(x + 2, y + 2).func_146112_a(GuiConfigs.mc(), mouseX, mouseY);
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            for (GuiItemButton button : this.itemButtons) {
                if (!button.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY)) continue;
                return true;
            }
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }
    }

    private class Category
    implements Iterable<GuiListExtended.IGuiListEntry> {
        private final GuiListExtended.IGuiListEntry titleEntry;
        private final List<ItemEntry> itemEntries;

        public Category(String modid, List<Item> items) {
            this.titleEntry = new GuiPropCat(modid.equals("minecraft") ? "Minecraft" : FMLCommonHandler.instance().findContainerFor((Object)modid).getName());
            Function<List<Item>, ItemEntry> getItemEntry = new Function<List<Item>, ItemEntry>(){

                public ItemEntry apply(List<Item> input) {
                    return new ItemEntry(input);
                }
            };
            this.itemEntries = FluentIterable.from((Iterable)Lists.partition(items, (int)GuiEditItemSet.this.itemsPerRow())).transform((Function)getItemEntry).toList();
        }

        @Override
        public Iterator<GuiListExtended.IGuiListEntry> iterator() {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.titleEntry), this.itemEntries.iterator());
        }
    }

    private class EmbededList
    extends GuiListExtended {
        private final PseudoIterator<GuiListExtended.IGuiListEntry> iterator;

        public EmbededList() {
            super(GuiConfigs.mc(), GuiEditItemSet.this.field_146294_l, GuiEditItemSet.this.field_146295_m, 33, GuiEditItemSet.this.field_146295_m - 32, 26);
            this.iterator = PseudoIterator.of(Iterables.concat((Iterable)GuiEditItemSet.this.categories));
            this.func_148130_a(false);
        }

        public GuiListExtended.IGuiListEntry func_148180_b(int index) {
            return this.iterator.next(index);
        }

        protected int func_148127_b() {
            return this.iterator.size();
        }

        protected int func_148137_d() {
            return this.field_148155_a - 45;
        }

        public int func_148139_c() {
            return GuiEditItemSet.this.field_146294_l;
        }
    }
}

