/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.projectile;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zotmc.tomahawk.LogTomahawk;
import zotmc.tomahawk.PositionTracker;
import zotmc.tomahawk.util.FieldAccess;
import zotmc.tomahawk.util.Obfs;
import zotmc.tomahawk.util.Utils;

public abstract class AbstractTomahawk
extends EntityArrow {
    private static final Field X = AbstractTomahawk.findField("field_145791_d");
    private static final Field Y = AbstractTomahawk.findField("field_145792_e");
    private static final Field Z = AbstractTomahawk.findField("field_145789_f");
    private static final Field TICKS_IN_GROUND = AbstractTomahawk.findField("ticksInGround", "field_70252_j");
    private static final Field TICKS_IN_AIR = AbstractTomahawk.findField("ticksInAir", "field_70257_an");
    private static final Field GROUND = AbstractTomahawk.findField("field_145790_g");
    private static final Field THROWER = AbstractTomahawk.findField("shootingEntity", "field_70250_c");
    protected final FieldAccess<Integer> x = FieldAccess.of(X, (Object)this);
    protected final FieldAccess<Integer> y = FieldAccess.of(Y, (Object)this);
    protected final FieldAccess<Integer> z = FieldAccess.of(Z, (Object)this);
    protected final FieldAccess<Integer> field_70252_j = FieldAccess.of(TICKS_IN_GROUND, (Object)this);
    protected final FieldAccess<Integer> field_70257_an = FieldAccess.of(TICKS_IN_AIR, (Object)this);
    protected final FieldAccess<Block> ground = FieldAccess.of(GROUND, (Object)this);
    protected final FieldAccess<Entity> thrower = FieldAccess.of(THROWER, (Object)this);

    private static Field findField(String ... names) {
        return Obfs.findField(EntityArrow.class, names);
    }

    public AbstractTomahawk(World world) {
        super(world);
    }

    public AbstractTomahawk(World world, double x, double y, double z, float initialSpeed) {
        super(world, x, y, z);
        this.func_70105_a(0.8f, 1.0f);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, initialSpeed, 1.0f);
    }

    public AbstractTomahawk(World world, EntityLivingBase thrower, float initialSpeed) {
        super(world, thrower, initialSpeed / 1.5f);
        this.func_70105_a(0.8f, 1.0f);
        this.func_70107_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v);
        if (!world.field_72995_K) {
            LogTomahawk.phy4j().debug("thrower: %s %s %s", new Object[]{thrower.field_70165_t, thrower.field_70163_u, thrower.field_70161_v});
            LogTomahawk.phy4j().debug("axe: %s %s %s", new Object[]{this.field_70165_t, this.field_70163_u, this.field_70161_v});
        }
        if (!world.field_72995_K) {
            if (thrower instanceof EntityPlayer) {
                double[] m = PositionTracker.get((EntityPlayer)thrower).getCurrentMotion();
                this.field_70159_w += m[0];
                this.field_70181_x += m[1];
                this.field_70179_y += m[2];
            } else {
                this.field_70159_w += thrower.field_70159_w;
                this.field_70181_x += thrower.field_70181_x;
                this.field_70179_y += thrower.field_70179_y;
            }
            this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, initialSpeed, 1.0f);
        }
        this.updateRotationYaw();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(5, (Object)0);
    }

    protected void setState(State state) {
        this.func_70096_w().func_75692_b(5, (Object)((byte)state.ordinal()));
    }

    private void setState(byte state) {
        this.func_70096_w().func_75692_b(5, (Object)state);
    }

    protected State getState() {
        return State.values()[this.func_70096_w().func_75683_a(5)];
    }

    private byte getStateByte() {
        return this.func_70096_w().func_75683_a(5);
    }

    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74774_a("state", this.getStateByte());
    }

    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.setState(tags.func_74771_c("state"));
    }

    public Entity getThrower() {
        return this.thrower.get();
    }

    protected int getLifespan() {
        return 1200;
    }

    public void func_70071_h_() {
        this.func_70030_z();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected boolean onLifespanTick(int lifespan) {
        if (this.field_70252_j.get() >= lifespan) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    protected void releaseToAir() {
        this.setState(State.IN_AIR);
        this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
        this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
        this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
        this.field_70252_j.set(0);
        this.field_70257_an.set(0);
        this.updateRotationYaw();
    }

    public void func_70030_z() {
        Vec3 pos1;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70030_z();
        switch (this.getState()) {
            case IN_GROUND: {
                if (this.field_70170_p.func_147439_a(this.x.get().intValue(), this.y.get().intValue(), this.z.get().intValue()) == this.ground.get()) {
                    this.field_70252_j.set(this.field_70252_j.get() + 1);
                    this.onLifespanTick(this.getLifespan());
                    return;
                }
                this.releaseToAir();
                break;
            }
            case ON_GROUND: {
                Block block = this.field_70170_p.func_147439_a(Utils.floor(this.field_70165_t), Utils.floor(this.field_70163_u) - 1, Utils.floor(this.field_70161_v));
                if (block.func_149688_o() != Material.field_151579_a) {
                    this.field_70252_j.set(this.field_70252_j.get() + 1);
                    this.onLifespanTick(this.getLifespan());
                    return;
                }
                this.releaseToAir();
                break;
            }
            case NO_REBOUNCE: {
                this.field_70257_an.set(this.field_70257_an.get() + 1);
                MovingObjectPosition mop = AbstractTomahawk.getBlockCollision(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (mop != null) {
                    this.field_70165_t = mop.field_72307_f.field_72450_a;
                    this.field_70163_u = mop.field_72307_f.field_72448_b;
                    this.field_70161_v = mop.field_72307_f.field_72449_c;
                    switch (ForgeDirection.getOrientation((int)mop.field_72310_e)) {
                        case UP: {
                            this.setState(State.ON_GROUND);
                        }
                        case DOWN: {
                            this.field_70181_x = 0.0;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            this.field_70159_w = 0.0;
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            this.field_70179_y = 0.0;
                            break;
                        }
                    }
                    if (Math.abs(this.field_70159_w) < 0.1 && Math.abs(this.field_70181_x) < 0.1 && Math.abs(this.field_70179_y) < 0.1) {
                        this.setState(State.ON_GROUND);
                    }
                    return;
                }
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
                double vH2 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
                double v2 = vH2 + this.field_70181_x * this.field_70181_x;
                this.onMotionTick(Utils.sqrt(vH2), Utils.sqrt(v2), this.getDragFactor());
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_145775_I();
                return;
            }
            default: {
                this.field_70257_an.set(this.field_70257_an.get() + 1);
            }
        }
        MovingObjectPosition mop = AbstractTomahawk.getBlockCollision(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        Vec3 pos = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 vec3 = pos1 = mop != null ? this.field_70170_p.func_82732_R().func_72345_a(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c) : this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            Entity nearest = null;
            MovingObjectPosition nearestIntercept = null;
            List onTrack = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.25, 1.5, 1.25));
            double min = 0.0;
            Entity thrower = this.getThrower();
            for (int i = 0; i < onTrack.size(); ++i) {
                double d;
                Entity candidate = (Entity)onTrack.get(i);
                if (!candidate.func_70089_S() || !candidate.func_70067_L() || candidate == thrower && this.field_70257_an.get() < 5) continue;
                AxisAlignedBB aabb = candidate.field_70121_D.func_72314_b(0.4, 0.5, 0.4);
                MovingObjectPosition intersect = AbstractTomahawk.calculateInterceptAdjusted(this.field_70170_p, aabb, pos, pos1);
                if (!(candidate instanceof EntityPlayer)) {
                    LogTomahawk.phy4j().debug("%s, %s", new Object[]{aabb.func_72318_a(pos), intersect != null});
                }
                if (intersect == null || !((d = pos.func_72438_d(intersect.field_72307_f)) < min) && min != 0.0) continue;
                nearest = candidate;
                nearestIntercept = intersect;
                min = d;
            }
            if (nearest != null) {
                mop = new MovingObjectPosition(nearest, nearestIntercept.field_72307_f);
                mop.hitInfo = nearestIntercept.hitInfo;
            }
        }
        if (mop != null) {
            this.onImpact(mop);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        double vH2 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
        double v2 = vH2 + this.field_70181_x * this.field_70181_x;
        this.onMotionTick(Utils.sqrt(vH2), Utils.sqrt(v2), this.getDragFactor());
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    protected static float modAngle(float rotation) {
        if (rotation < 0.0f) {
            while (rotation < -180.0f) {
                rotation += 360.0f;
            }
        } else {
            while (rotation >= 180.0f) {
                rotation -= 360.0f;
            }
        }
        return rotation;
    }

    public void updateRotationYaw() {
        this.field_70177_z = AbstractTomahawk.modAngle(Utils.atan2(this.field_70159_w, this.field_70179_y) * 180.0f / (float)Math.PI);
    }

    public static MovingObjectPosition getBlockCollision(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        Vec3 pos = world.func_82732_R().func_72345_a(posX, posY, posZ);
        Vec3 pos1 = world.func_82732_R().func_72345_a(posX + motionX, posY + motionY, posZ + motionZ);
        return world.func_147447_a(pos, pos1, false, true, false);
    }

    private static MovingObjectPosition calculateInterceptAdjusted(World world, AxisAlignedBB aabb, Vec3 a, Vec3 b) {
        MovingObjectPosition ret = AbstractTomahawk.calculateIntercept(world, aabb, a, b);
        if (ret != null) {
            Vec3 normal;
            if (ret.field_72310_e == ForgeDirection.UP.ordinal()) {
                normal = world.func_82732_R().func_72345_a(0.0, 1.0, 0.0);
            } else if (ret.field_72310_e == ForgeDirection.DOWN.ordinal()) {
                normal = world.func_82732_R().func_72345_a(0.0, -1.0, 0.0);
            } else {
                double x = ret.field_72307_f.field_72450_a - (aabb.field_72340_a + aabb.field_72336_d) / 2.0;
                double z = ret.field_72307_f.field_72449_c - (aabb.field_72339_c + aabb.field_72334_f) / 2.0;
                double r = Utils.sqrt(x * x + z * z);
                double x1 = a.field_72450_a - b.field_72450_a;
                double z1 = a.field_72449_c - b.field_72449_c;
                double r1 = Utils.sqrt(x1 * x1 + z1 * z1);
                x = x / r * 2.5 + x1 / r1;
                z = z / r * 2.5 + z1 / r1;
                r = Utils.sqrt(x * x + z * z);
                normal = world.func_82732_R().func_72345_a(x / r, 0.0, z / r);
            }
            ret.hitInfo = normal;
        }
        return ret;
    }

    private static MovingObjectPosition calculateIntercept(World world, AxisAlignedBB aabb, Vec3 a, Vec3 b) {
        Vec3 x = AbstractTomahawk.getIntermediateWithXValue(world, a, b, b.field_72450_a < a.field_72450_a ? aabb.field_72336_d : aabb.field_72340_a);
        Vec3 y = AbstractTomahawk.getIntermediateWithYValue(world, a, b, b.field_72448_b < a.field_72448_b ? aabb.field_72337_e : aabb.field_72338_b);
        Vec3 z = AbstractTomahawk.getIntermediateWithZValue(world, a, b, b.field_72449_c < a.field_72449_c ? aabb.field_72334_f : aabb.field_72339_c);
        if (!aabb.func_72318_a(a)) {
            if (!(x == null || AbstractTomahawk.isVecInY(aabb, x) && AbstractTomahawk.isVecInZ(aabb, x))) {
                x = null;
            }
            if (!(y == null || AbstractTomahawk.isVecInX(aabb, y) && AbstractTomahawk.isVecInZ(aabb, y))) {
                y = null;
            }
            if (!(z == null || AbstractTomahawk.isVecInX(aabb, z) && AbstractTomahawk.isVecInY(aabb, z))) {
                z = null;
            }
        }
        Vec3 hit = null;
        if (x != null && (hit == null || a.func_72436_e(x) < a.func_72436_e(hit))) {
            hit = x;
        }
        if (y != null && (hit == null || a.func_72436_e(y) < a.func_72436_e(hit))) {
            hit = y;
        }
        if (z != null && (hit == null || a.func_72436_e(z) < a.func_72436_e(hit))) {
            hit = z;
        }
        if (hit != null) {
            ForgeDirection face = null;
            if (hit == x) {
                face = b.field_72450_a < a.field_72450_a ? ForgeDirection.EAST : ForgeDirection.WEST;
            } else if (hit == y) {
                face = b.field_72448_b < a.field_72448_b ? ForgeDirection.UP : ForgeDirection.DOWN;
            } else if (hit == z) {
                face = b.field_72449_c < a.field_72449_c ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
            }
            return new MovingObjectPosition(0, 0, 0, face.ordinal(), hit);
        }
        return null;
    }

    private static boolean isVecInX(AxisAlignedBB aabb, Vec3 vec) {
        return vec.field_72450_a >= aabb.field_72340_a && vec.field_72450_a <= aabb.field_72336_d;
    }

    private static boolean isVecInY(AxisAlignedBB aabb, Vec3 vec) {
        return vec.field_72448_b >= aabb.field_72338_b && vec.field_72448_b <= aabb.field_72337_e;
    }

    private static boolean isVecInZ(AxisAlignedBB aabb, Vec3 vec) {
        return vec.field_72449_c >= aabb.field_72339_c && vec.field_72449_c <= aabb.field_72334_f;
    }

    private static Vec3 getIntermediateWithXValue(World world, Vec3 a, Vec3 b, double k) {
        double x = b.field_72450_a - a.field_72450_a;
        double y = b.field_72448_b - a.field_72448_b;
        double z = b.field_72449_c - a.field_72449_c;
        double r = (k - a.field_72450_a) / x;
        if (!Double.isNaN(r)) {
            x = k;
            y = a.field_72448_b + y * r;
            z = a.field_72449_c + z * r;
            if (!Double.isNaN(y) && !Double.isNaN(z)) {
                return world.func_82732_R().func_72345_a(x, y, z);
            }
        }
        return null;
    }

    private static Vec3 getIntermediateWithYValue(World world, Vec3 a, Vec3 b, double k) {
        double x = b.field_72450_a - a.field_72450_a;
        double y = b.field_72448_b - a.field_72448_b;
        double z = b.field_72449_c - a.field_72449_c;
        double r = (k - a.field_72448_b) / y;
        if (!Double.isNaN(r)) {
            x = a.field_72450_a + x * r;
            y = k;
            z = a.field_72449_c + z * r;
            if (!Double.isNaN(x) && !Double.isNaN(z)) {
                return world.func_82732_R().func_72345_a(x, y, z);
            }
        }
        return null;
    }

    private static Vec3 getIntermediateWithZValue(World world, Vec3 a, Vec3 b, double k) {
        double x = b.field_72450_a - a.field_72450_a;
        double y = b.field_72448_b - a.field_72448_b;
        double z = b.field_72449_c - a.field_72449_c;
        double r = (k - a.field_72449_c) / z;
        if (!Double.isNaN(r)) {
            x = a.field_72450_a + x * r;
            y = a.field_72448_b + y * r;
            z = k;
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                return world.func_82732_R().func_72345_a(x, y, z);
            }
        }
        return null;
    }

    protected void onMotionTick(float vH, float v, float resistense) {
        float r = MathHelper.func_76131_a((float)(1.0f - resistense / v), (float)0.0f, (float)1.0f);
        float g = this.getGravity();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float tail = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)tail, this.field_70163_u - this.field_70181_x * (double)tail, this.field_70161_v - this.field_70179_y * (double)tail, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            r *= 0.8f;
        }
        this.field_70159_w *= (double)r;
        this.field_70181_x *= (double)r;
        this.field_70179_y *= (double)r;
        this.field_70181_x -= (double)g;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.x.set(mop.field_72311_b);
            this.y.set(mop.field_72312_c);
            this.z.set(mop.field_72309_d);
            Block b = this.field_70170_p.func_147439_a(this.x.get().intValue(), this.y.get().intValue(), this.z.get().intValue());
            this.ground.set(b);
            this.field_70159_w = mop.field_72307_f.field_72450_a - this.field_70165_t;
            this.field_70181_x = mop.field_72307_f.field_72448_b - this.field_70163_u;
            this.field_70179_y = mop.field_72307_f.field_72449_c - this.field_70161_v;
            float v = Utils.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
            this.field_70165_t -= this.field_70159_w / (double)v * 0.05;
            this.field_70163_u -= this.field_70181_x / (double)v * 0.05;
            this.field_70161_v -= this.field_70179_y / (double)v * 0.05;
            if (b.func_149688_o() != Material.field_151579_a) {
                this.playHitSound(true, b, b.func_149712_f(this.field_70170_p, this.x.get().intValue(), this.y.get().intValue(), this.z.get().intValue()));
                this.setState(State.IN_GROUND);
                b.func_149670_a(this.field_70170_p, this.x.get().intValue(), this.y.get().intValue(), this.z.get().intValue(), (Entity)this);
            }
        }
    }

    protected void playHitSound(boolean isStationary, Block block, float hardness) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_85030_a("random.bowhit", 1.4f, (1.2f / this.field_70146_Z.nextFloat() * 0.2f + 0.9f) * 3.0f / 5.0f);
        }
    }

    protected void playInAirSound(double v2) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_85030_a("random.bow", MathHelper.func_76131_a((float)((float)v2 * 16.0f), (float)0.0f, (float)1.0f), 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.5f);
        }
    }

    protected void rebounce(MovingObjectPosition mop, double reactFactor, boolean onEntity) {
        Vec3 nVec = (Vec3)mop.hitInfo;
        Vec3 vVec = this.field_70170_p.func_82732_R().func_72345_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.onRebounce(mop, nVec.field_72448_b, nVec.func_72433_c(), -reactFactor * nVec.func_72430_b(vVec));
        double r = 2.0 * (this.field_70159_w * nVec.field_72450_a + this.field_70181_x * nVec.field_72448_b + this.field_70179_y * nVec.field_72449_c);
        this.field_70159_w = reactFactor * (this.field_70159_w - r * nVec.field_72450_a);
        this.field_70181_x = reactFactor * (this.field_70181_x - r * nVec.field_72448_b);
        this.field_70179_y = reactFactor * (this.field_70179_y - r * nVec.field_72449_c);
        double pX = mop.field_72307_f.field_72450_a + this.field_70159_w * 0.05;
        double pY = mop.field_72307_f.field_72448_b + this.field_70181_x * 0.05;
        double pZ = mop.field_72307_f.field_72449_c + this.field_70179_y * 0.05;
        MovingObjectPosition mop1 = AbstractTomahawk.getBlockCollision(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, pX - this.field_70165_t, pY - this.field_70163_u, pZ - this.field_70161_v);
        if (mop1 != null) {
            this.onImpact(mop1);
        }
        this.updateRotationYaw();
    }

    protected abstract void onRebounce(MovingObjectPosition var1, double var2, double var4, double var6);

    protected float getDragFactor() {
        return 0.06f;
    }

    protected float getGravity() {
        return 0.12f;
    }

    public static enum State {
        IN_AIR,
        IN_GROUND,
        NO_REBOUNCE,
        ON_GROUND;

    }
}

