/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Obfs {
    private static final Field MODIFIERS;

    public static Field findField(Class<?> clz, String ... names) {
        Field f = null;
        for (String s : ObfuscationReflectionHelper.remapFieldNames((String)clz.getName(), (String[])names)) {
            try {
                f = clz.getDeclaredField(s);
                f.setAccessible(true);
                break;
            }
            catch (Throwable ignored) {
            }
        }
        return (Field)Preconditions.checkNotNull(f);
    }

    public static Field findFieldFinal(Class<?> clz, String ... names) {
        Field f = Obfs.findField(clz, names);
        try {
            MODIFIERS.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
        return f;
    }

    public static MethodFinder findMethod(Class<?> clz, String ... names) {
        return new MethodFinder(clz, names);
    }

    private static String[] remapMethodNames(String className, String ... methodNames) {
        String internalClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(className.replace('.', '/'));
        String[] mappedNames = new String[methodNames.length];
        int i = 0;
        for (String mName : methodNames) {
            mappedNames[i++] = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, mName, null);
        }
        return mappedNames;
    }

    static {
        Field f = null;
        try {
            f = Field.class.getDeclaredField("modifiers");
            f.setAccessible(true);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
        MODIFIERS = f;
    }

    public static class MethodFinder {
        private final Class<?> clz;
        private final String[] names;

        private MethodFinder(Class<?> clz, String[] names) {
            this.clz = clz;
            this.names = names;
        }

        public Method withArgs(Class<?> ... parameterTypes) {
            Method m = null;
            for (String s : Obfs.remapMethodNames(this.clz.getName(), this.names)) {
                try {
                    m = this.clz.getDeclaredMethod(s, parameterTypes);
                    m.setAccessible(true);
                    break;
                }
                catch (Throwable ignored) {
                }
            }
            return (Method)Preconditions.checkNotNull(m);
        }
    }
}

