/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public class PseudoIterator<E> {
    private final Iterable<E> iterable;
    private Iterator<E> backing;
    private int currentIndex;
    private E lastElement;

    private PseudoIterator(Iterable<E> iterable) {
        this.iterable = iterable;
        this.backing = iterable.iterator();
    }

    public static <E> PseudoIterator<E> of(Iterable<E> iterable) {
        return new PseudoIterator<E>(iterable);
    }

    public E next(int index) {
        if (index == this.currentIndex - 1) {
            return this.lastElement;
        }
        if (index > this.currentIndex) {
            Iterators.advance(this.backing, (int)(index - this.currentIndex));
        } else if (index < this.currentIndex) {
            this.backing = this.iterable.iterator();
            Iterators.advance(this.backing, (int)index);
        }
        this.currentIndex = index + 1;
        this.lastElement = this.backing.next();
        return this.lastElement;
    }

    public int size() {
        return Iterables.size(this.iterable);
    }
}

