/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class StandardImpls {

    public static class SetImpl
    extends CollectionImpl {
        public static boolean removeAll(Set<?> set, Collection<?> c) {
            if (c instanceof Multiset) {
                c = ((Multiset)c).elementSet();
            }
            boolean changed = false;
            if (c instanceof Set && c.size() > set.size()) {
                Iterator<?> ite = set.iterator();
                while (ite.hasNext()) {
                    if (!c.contains(ite.next())) continue;
                    changed = true;
                    ite.remove();
                }
                return changed;
            }
            for (Object obj : c) {
                changed |= set.remove(obj);
            }
            return changed;
        }

        public static int hashCode(Set<?> set) {
            int h = 0;
            for (Object o : set) {
                if (o == null) continue;
                h += o.hashCode();
            }
            return h;
        }

        public static boolean equals(Set<?> set, Object obj) {
            if (obj == set) {
                return true;
            }
            if (obj instanceof Set) {
                try {
                    Set o = (Set)obj;
                    return o.size() == set.size() && set.containsAll(o);
                }
                catch (NullPointerException ignored) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static class CollectionImpl {
        public static <E> boolean addAll(Collection<E> collection, Collection<? extends E> c) {
            return Iterators.addAll(collection, c.iterator());
        }

        public static boolean retainAll(Collection<?> collection, Collection<?> c) {
            return Iterators.retainAll(collection.iterator(), c);
        }

        public static boolean containsAll(Collection<?> collection, Collection<?> c) {
            for (Object e : c) {
                if (collection.contains(e)) continue;
                return false;
            }
            return true;
        }

        public static Object[] toArray(Collection<?> collection) {
            return Iterators.toArray(collection.iterator(), Object.class);
        }

        public static <E, T> T[] toArray(Collection<E> collection, T[] a) {
            int size = collection.size();
            if (a.length < size) {
                a = ObjectArrays.newArray((Object[])a, (int)size);
            }
            int i = 0;
            for (E element : collection) {
                a[i++] = element;
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        public static String toString(Collection<?> collection) {
            return Iterators.toString(collection.iterator());
        }

        public static boolean remove(Collection<?> collection, Object o) {
            Iterator<?> it = collection.iterator();
            while (it.hasNext()) {
                if (!Objects.equal(it.next(), (Object)o)) continue;
                it.remove();
                return true;
            }
            return false;
        }

        public static boolean removeAll(Collection<?> collection, Collection<?> c) {
            return Iterators.removeAll(collection.iterator(), c);
        }
    }
}

