/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zotmc.tomahawk.config.Config;

public class LogTomahawk {
    private static Logger mob;
    private static Logger proj;
    private static Logger phy;

    public static Logger mob4j() {
        return mob != null ? mob : (mob = LogTomahawk.create(LogCategory.MOB));
    }

    public static Logger pro4j() {
        return proj != null ? proj : (proj = LogTomahawk.create(LogCategory.PROJ));
    }

    public static Logger phy4j() {
        return phy != null ? phy : (phy = LogTomahawk.create(LogCategory.PHY));
    }

    public static boolean isDebugEnabled(LogCategory cat, Object[] args) {
        return ((Set)Config.current().debugLoggings.get()).contains((Object)cat);
    }

    private static Logger create(final LogCategory cat) {
        return (Logger)Proxy.newProxyInstance(LogTomahawk.class.getClassLoader(), new Class[]{Logger.class}, new InvocationHandler(){
            final Logger delegatee;
            {
                this.delegatee = LogManager.getFormatterLogger((String)("axetomahawk." + (Object)((Object)cat)));
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("debug")) {
                    return !LogTomahawk.isDebugEnabled(cat, args) ? null : Logger.class.getDeclaredMethod("info", method.getParameterTypes()).invoke((Object)this.delegatee, args);
                }
                if (args.length > 0 && args[0] == Level.DEBUG) {
                    if (!LogTomahawk.isDebugEnabled(cat, args)) {
                        return null;
                    }
                    args[0] = Level.INFO;
                }
                return method.invoke((Object)this.delegatee, args);
            }
        });
    }

    public static enum LogCategory {
        MOB,
        PROJ,
        PHY;

    }
}

