/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.Configuration;
import zotmc.tomahawk.LogTomahawk;
import zotmc.tomahawk.config.Configurable;
import zotmc.tomahawk.config.ConfigurableBoolean;
import zotmc.tomahawk.config.ConfigurableEnumSet;
import zotmc.tomahawk.config.ConfigurableItemIdSet;
import zotmc.tomahawk.config.GuiConfigs;
import zotmc.tomahawk.config.GuiEdit;
import zotmc.tomahawk.util.FieldAccess;
import zotmc.tomahawk.util.Holder;

public class Config {
    private static final String GENERAL = "general";
    private static final String COMPS = "compatibilities";
    public final Configurable<Boolean> commonAxesThrowing = new ConfigurableBoolean("general", "commonAxesThrowing").set(true);
    public final ConfigurableItemIdSet axeBlacklist = new ConfigurableItemIdSet("general", "axeBlacklist");
    public final Configurable<Set<LogTomahawk.LogCategory>> debugLoggings = ConfigurableEnumSet.of(LogTomahawk.LogCategory.class, "general", "debugLoggings");
    public final Configurable<Boolean> tiCHatchetsThrowing = new ConfigurableBoolean("compatibilities", "tiCHatchetsThrowing").set(true);
    public final Configurable<Boolean> tiCFryingPansThrowing = new ConfigurableBoolean("compatibilities", "tiCFryingPansThrowing");
    private static Configuration configFile;
    private static Holder<ConfigState> configState;
    private static Config preserved;
    private static Config current;
    private Config inspect;

    Config() {
    }

    public static void init(Configuration configFile, Holder<ConfigState> configState) {
        if (Config.configFile != null) {
            throw new IllegalStateException("Already initialized");
        }
        Config.configFile = (Configuration)Preconditions.checkNotNull((Object)configFile);
        Config.configState = (Holder)Preconditions.checkNotNull(configState);
        current = new Config().load().save();
        configState.set(ConfigState.AVAILABLE);
    }

    static Config preserved() {
        return preserved != null ? preserved : (preserved = current.copy());
    }

    public static Config current() {
        return configState.get() == ConfigState.AVAILABLE ? current : Config.current.inspect;
    }

    @SideOnly(value=Side.CLIENT)
    void endInspect(GuiScreen parent) {
        this.inspect = null;
        configState.set(ConfigState.AVAILABLE);
        GuiConfigs.mc().func_147108_a(parent);
    }

    @SideOnly(value=Side.CLIENT)
    Config beginInspect(Config config, GuiEdit gui) {
        if (configState.get() != ConfigState.AVAILABLE) {
            throw new IllegalStateException("Illegal Config State: " + (Object)((Object)configState.get()));
        }
        configState.set(ConfigState.INSPECTING);
        this.inspect = config;
        GuiConfigs.mc().func_147108_a((GuiScreen)gui);
        return this;
    }

    private static Iterable<Field> getConfigurableFields() {
        return FluentIterable.from(Arrays.asList(Config.class.getDeclaredFields())).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                return !Modifier.isStatic(input.getModifiers()) && Configurable.class.isAssignableFrom(input.getType());
            }
        });
    }

    Config apply(Config config) {
        for (Field f : Config.getConfigurableFields()) {
            ((Configurable)FieldAccess.of(f, this).get()).set(((Configurable)FieldAccess.of(f, config).get()).get());
        }
        return this;
    }

    Config applyHot(Config config) {
        return this.apply(config);
    }

    Config load() {
        for (Field f : Config.getConfigurableFields()) {
            ((Configurable)FieldAccess.of(f, this).get()).load(configFile);
        }
        return this;
    }

    Config save() {
        for (Field f : Config.getConfigurableFields()) {
            ((Configurable)FieldAccess.of(f, this).get()).save(configFile);
        }
        return this;
    }

    Config copy() {
        return new Config().apply(this);
    }

    public static enum ConfigState {
        INSPECTING,
        AVAILABLE;

    }
}

