/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.config;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import zotmc.tomahawk.config.Configurable;

public abstract class ConfigurableStringList<T extends Iterable<U>, U>
extends Configurable<T> {
    protected T value = this.getInitialValue();

    public ConfigurableStringList(String category, String key) {
        super(category, key);
    }

    protected abstract T getInitialValue();

    protected abstract Function<U, String> toStringFunction();

    protected abstract Function<String, U> valueOfFunction();

    public T get() {
        return this.value;
    }

    protected String[] getStringList() {
        return (String[])FluentIterable.from(this.value).transform(this.toStringFunction()).toArray(String.class);
    }

    @Override
    Configurable<T> set(T value) {
        this.value = value;
        return this;
    }

    protected abstract void setIterable(FluentIterable<U> var1);

    @Override
    void load(Configuration configFile) {
        String[] a = configFile.get(this.category, this.key, this.getStringList()).getStringList();
        this.setIterable(FluentIterable.from(Arrays.asList(a)).transform(this.valueOfFunction()));
    }

    @Override
    void save(Configuration configFile) {
        configFile.get(this.category, this.key, new String[0]).set(this.getStringList());
        configFile.save();
    }
}

