/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.projectile;

import com.google.common.collect.Range;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.ref.WeakReference;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import zotmc.tomahawk.Enchs;
import zotmc.tomahawk.LogTomahawk;
import zotmc.tomahawk.TomahawkRegistry;
import zotmc.tomahawk.projectile.AbstractTomahawk;
import zotmc.tomahawk.projectile.PlayerTomahawk;
import zotmc.tomahawk.projectile.TomahawkDamage;
import zotmc.tomahawk.util.Utils;

public class EntityTomahawk
extends AbstractTomahawk {
    private static final Random RAND = new Random();
    public final float aRoll;
    public final float bRoll;
    public PickUpType pickUpType;
    float damageAttr;
    int knockbackStr;
    public WeakReference<PlayerTomahawk> fakePlayer;
    private static final Range<Float> ANGLE_RANGE = Range.closed((Comparable)Float.valueOf(Utils.atan(0.4444444444444444) * 180.0f / (float)Math.PI - 45.0f), (Comparable)Float.valueOf(180.0f - Utils.atan(2.0) * 180.0f / (float)Math.PI));
    protected static final float INITIAL_SPEED = 2.11f;

    public EntityTomahawk(World world) {
        super(world);
        this.aRoll = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 15.0f / 2.0f : 0.0f;
        this.bRoll = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 1.0f / 2.0f : 0.0f;
        this.pickUpType = PickUpType.SURVIVAL;
        this.fakePlayer = new WeakReference<Object>(null);
    }

    public EntityTomahawk(World world, double x, double y, double z, ItemStack item) {
        super(world, x, y, z, 2.11f);
        this.aRoll = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 15.0f / 2.0f : 0.0f;
        this.bRoll = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 1.0f / 2.0f : 0.0f;
        this.pickUpType = PickUpType.SURVIVAL;
        this.fakePlayer = new WeakReference<Object>(null);
        this.setItem(item);
        if (!world.field_72995_K) {
            ServersideAttributeMap attrs = new ServersideAttributeMap();
            attrs.func_111150_b(SharedMonsterAttributes.field_111264_e);
            attrs.func_111147_b(item.func_111283_C());
            this.damageAttr = (float)attrs.func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        }
    }

    public EntityTomahawk(World world, EntityLivingBase thrower, ItemStack item) {
        super(world, thrower, 2.11f);
        this.aRoll = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 15.0f / 2.0f : 0.0f;
        this.bRoll = this.field_70170_p.field_72995_K ? (float)RAND.nextGaussian() * 1.0f / 2.0f : 0.0f;
        this.pickUpType = PickUpType.SURVIVAL;
        this.fakePlayer = new WeakReference<Object>(null);
        this.setItem(item);
        if (!world.field_72995_K) {
            this.damageAttr = (float)thrower.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            if (thrower.func_70051_ag()) {
                this.knockbackStr = 1;
            }
            if (!(!(thrower.field_70143_R > 0.0f) || thrower.field_70122_E || thrower.func_70617_f_() || thrower.func_70090_H() || thrower.func_70644_a(Potion.field_76440_q) || thrower.field_70154_o != null)) {
                this.func_70243_d(true);
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(2, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_75682_a(3, (Object)-1);
        this.func_70096_w().func_75682_a(4, (Object)1);
        this.func_70096_w().func_82709_a(10, 5);
    }

    public void setRotation(float value) {
        this.func_70096_w().func_75692_b(2, (Object)Float.valueOf(value));
    }

    public float getRotation() {
        return this.func_70096_w().func_111145_d(2);
    }

    public void setAfterHit(int value) {
        this.func_70096_w().func_75692_b(3, (Object)value);
    }

    public int getAfterHit() {
        return this.func_70096_w().func_75679_c(3);
    }

    public void setIsForwardSpin(boolean value) {
        this.func_70096_w().func_75692_b(4, (Object)(value ? (byte)1 : 0));
    }

    public boolean getIsForwardSpin() {
        return (this.func_70096_w().func_75683_a(4) & 1) != 0;
    }

    public void setItem(ItemStack value) {
        this.func_70096_w().func_75692_b(10, (Object)value);
        this.func_70096_w().func_82708_h(10);
    }

    public ItemStack getItem() {
        return this.func_70096_w().func_82710_f(10);
    }

    @Override
    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74776_a("rotation", this.getRotation());
        tags.func_74768_a("ticksAfterHit", this.getAfterHit());
        tags.func_74757_a("isForwardSpin", this.getIsForwardSpin());
        tags.func_74774_a("pickUpType", (byte)this.pickUpType.ordinal());
        tags.func_74782_a("item", (NBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
        tags.func_74776_a("damageAttr", this.damageAttr);
        tags.func_74777_a("knockbackStr", (short)this.knockbackStr);
    }

    @Override
    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.setRotation(tags.func_74760_g("rotation"));
        this.setAfterHit(tags.func_74762_e("ticksAfterHit"));
        this.setIsForwardSpin(tags.func_74767_n("isForwardSpin"));
        this.pickUpType = PickUpType.values()[tags.func_74771_c("pickUpType")];
        this.setItem(ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("item")));
        this.damageAttr = tags.func_74760_g("damageAttr");
        this.knockbackStr = tags.func_74765_d("knockbackStr");
    }

    @Override
    public int getLifespan() {
        switch (this.pickUpType) {
            case SURVIVAL: {
                ItemStack item = this.getItem();
                return item != null ? item.func_77973_b().getEntityLifespan(item, this.field_70170_p) : 120;
            }
            case ENCH: {
                return 120;
            }
        }
        return super.getLifespan();
    }

    public boolean readyForPickUp() {
        return this.getState() != AbstractTomahawk.State.IN_AIR || this.getAfterHit() >= 5;
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.readyForPickUp()) {
            boolean pickedUp = this.pickUpType.canBePickedUpBy(PickUpType.SURVIVAL) || player.field_71075_bZ.field_75098_d && this.pickUpType.canBePickedUpBy(PickUpType.CREATIVE);
            ItemStack item = this.getItem();
            if (this.pickUpType.canBePickedUpBy(PickUpType.SURVIVAL) && !player.field_71071_by.func_70441_a(item)) {
                pickedUp = false;
            }
            if (pickedUp) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, item.field_77994_a);
                this.func_70106_y();
                LogTomahawk.pro4j().debug("An EntityTomahawk %s [PickUpType: %s] has been picked up by EntityPlayer %s", new Object[]{this.getItem(), this.pickUpType, player.func_145782_y()});
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getState() == AbstractTomahawk.State.IN_AIR || this.getState() == AbstractTomahawk.State.NO_REBOUNCE) {
            this.setRotation(EntityTomahawk.modAngle(this.getRotation() + 56.0f * this.getSpinFactor(false)));
            float p = 7.0f / this.getSpinFactor(false);
            float t = (float)((Integer)this.field_70257_an.get()).intValue() % p;
            if (t >= p - 1.0f) {
                this.playInAirSound(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
            }
            if (this.getAfterHit() < 0) {
                int i;
                if (this.func_70241_g()) {
                    for (i = 0; i < 4; ++i) {
                        this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                    }
                }
                if (this.field_70170_p.field_72995_K && this.getItem().func_77948_v()) {
                    for (i = 0; i < 3; ++i) {
                        if (RAND.nextInt(4) != 0) continue;
                        this.field_70170_p.func_72869_a("magicCrit", this.field_70165_t + this.field_70159_w * (double)i / 3.0, this.field_70163_u + this.field_70181_x * (double)i / 3.0, this.field_70161_v + this.field_70179_y * (double)i / 3.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                    }
                }
            } else {
                this.setAfterHit(this.getAfterHit() + 1);
            }
        }
    }

    @Override
    protected boolean onLifespanTick(int lifespan) {
        if (super.onLifespanTick(lifespan)) {
            LogTomahawk.pro4j().debug("An EntityTomahawk %s [State: %s][Pos: %.0f %.0f %.0f] has its lifespan %s expired", new Object[]{this.getItem(), this.getState(), this.field_70165_t, this.field_70163_u, this.field_70161_v, lifespan});
            return true;
        }
        return false;
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (this.getAfterHit() < 0 && mop.field_72308_g != null) {
            ItemStack item = this.getItem();
            boolean flag = this.field_70170_p.field_72995_K;
            if (!flag && this.field_70170_p instanceof WorldServer) {
                PlayerTomahawk fakePlayer = new PlayerTomahawk((WorldServer)this.field_70170_p, this);
                flag = !MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)fakePlayer, mop.field_72308_g)) && !item.func_77973_b().onLeftClickEntity(item, (EntityPlayer)fakePlayer, mop.field_72308_g);
                this.fakePlayer = new WeakReference<PlayerTomahawk>(fakePlayer);
            }
            if (flag && mop.field_72308_g.func_70075_an() && !mop.field_72308_g.func_85031_j((Entity)this)) {
                float damage = this.damageAttr;
                float enchCrit = 0.0f;
                int knock = this.knockbackStr;
                if (mop.field_72308_g instanceof EntityLivingBase) {
                    enchCrit = Enchs.getEnchantmentModifierLiving(item, (EntityLivingBase)mop.field_72308_g);
                    knock += EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)item);
                }
                if (damage > 0.0f || enchCrit > 0.0f) {
                    Entity thrower;
                    boolean attacked;
                    boolean critical;
                    boolean bl = critical = this.func_70241_g() && mop.field_72308_g instanceof EntityLivingBase;
                    if (critical && damage > 0.0f) {
                        damage *= 1.5f;
                    }
                    damage += enchCrit;
                    boolean setFire = false;
                    int fire = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)item);
                    if (fire > 0 && mop.field_72308_g instanceof EntityLivingBase && !mop.field_72308_g.func_70027_ad()) {
                        setFire = true;
                        mop.field_72308_g.func_70015_d(1);
                    }
                    if (attacked = mop.field_72308_g.func_70097_a((DamageSource)new TomahawkDamage(this, (Entity)((thrower = this.getThrower()) != null ? thrower : this)), damage)) {
                        IEntityMultiPart dragon;
                        if (knock > 0) {
                            float hv = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                            mop.field_72308_g.func_70024_g((double)((float)this.field_70159_w / hv * (float)knock * 0.5f), 0.1, (double)((float)this.field_70179_y / hv * (float)knock * 0.5f));
                            this.field_70159_w *= 0.6;
                            this.field_70179_y *= 0.6;
                        }
                        if (critical) {
                            Utils.onCritical((Entity)this, mop.field_72308_g);
                        }
                        if (enchCrit > 0.0f) {
                            Utils.onEnchantmentCritical((Entity)this, mop.field_72308_g);
                        }
                        if (thrower instanceof EntityLivingBase) {
                            try {
                                Enchs.applyEnchantmentDamageIterator((EntityLivingBase)thrower, item, mop.field_72308_g);
                            }
                            catch (Throwable ignored) {
                                // empty catch block
                            }
                        }
                        Entity entity = mop.field_72308_g;
                        if (mop.field_72308_g instanceof EntityDragonPart && (dragon = ((EntityDragonPart)mop.field_72308_g).field_70259_a) != null && dragon instanceof EntityLivingBase) {
                            entity = (Entity)dragon;
                        }
                        if (item != null && entity instanceof EntityLivingBase) {
                            if (thrower instanceof EntityPlayer) {
                                item.func_77961_a((EntityLivingBase)entity, (EntityPlayer)thrower);
                            } else {
                                item.func_96631_a(2, this.field_70146_Z);
                            }
                            if (item.field_77994_a <= 0) {
                                this.func_70106_y();
                                this.func_85030_a("random.break", 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                                LogTomahawk.pro4j().debug("An EntityTomahawk %s has been destroyed while hitting %s %s", new Object[]{this.getItem(), entity.getClass().getSimpleName(), entity.func_145782_y()});
                            }
                        }
                        if (mop.field_72308_g instanceof EntityLivingBase && fire > 0) {
                            mop.field_72308_g.func_70015_d(fire * 4);
                        }
                    } else if (setFire) {
                        mop.field_72308_g.func_70066_B();
                    }
                }
            }
            this.rebounce(mop, this.getReactFactor(), true);
            this.setAfterHit(0);
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            boolean setInGround;
            boolean bl = setInGround = this.getState() != AbstractTomahawk.State.ON_GROUND;
            if (setInGround) {
                float angle = this.getRotation() + 45.0f;
                if (mop.field_72310_e == ForgeDirection.DOWN.ordinal()) {
                    angle += (float)(90 * (this.getIsForwardSpin() ? 1 : -1));
                } else if (mop.field_72310_e == ForgeDirection.UP.ordinal()) {
                    angle -= (float)(90 * (this.getIsForwardSpin() ? 1 : -1));
                }
                setInGround = ANGLE_RANGE.contains((Comparable)Float.valueOf(EntityTomahawk.modAngle(angle)));
            }
            if (setInGround) {
                ItemStack item = this.getItem();
                if (item != null && this.field_70170_p instanceof WorldServer) {
                    PlayerTomahawk fakePlayer = new PlayerTomahawk((WorldServer)this.field_70170_p, this);
                    item.func_77973_b().onBlockStartBreak(item, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, (EntityPlayer)fakePlayer);
                    this.fakePlayer = new WeakReference<PlayerTomahawk>(fakePlayer);
                }
                super.onImpact(mop);
                this.func_70243_d(false);
            } else {
                ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
                mop.hitInfo = this.field_70170_p.func_82732_R().func_72345_a((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
                this.rebounce(mop, this.getReactFactorOnBlock(), false);
                double v2 = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
                if (v2 < 0.1111111111111111) {
                    this.setState(AbstractTomahawk.State.NO_REBOUNCE);
                    this.func_70243_d(false);
                }
                Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                this.playHitSound(false, block, block.func_149712_f(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d));
            }
        }
    }

    @Override
    protected void onMotionTick(float vH, float v, float resistance) {
        super.onMotionTick(vH, v, resistance);
        if (this.getState() != AbstractTomahawk.State.ON_GROUND) {
            double wZ;
            double wX;
            float k = this.getSpinMotionFactor() * this.getSpinFactor(true);
            double wH = (double)(-k) * this.field_70181_x;
            double wY = k * vH;
            double r = this.field_70179_y / this.field_70159_w;
            if (!Double.isNaN(r)) {
                wX = wH / (double)Utils.sqrt(1.0 + r * r);
                wZ = r * wX;
            } else {
                wX = (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * wH;
                wZ = (double)MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * wH;
            }
            this.field_70159_w += wX;
            this.field_70181_x += wY;
            this.field_70179_y += wZ;
        }
    }

    @Override
    protected void rebounce(MovingObjectPosition mop, double reactFactor, boolean onEntity) {
        float p = this.field_70177_z;
        super.rebounce(mop, reactFactor, onEntity);
        if (EntityTomahawk.modAngle(this.field_70177_z - p - 90.0f) >= 0.0f) {
            this.setIsForwardSpin(!this.getIsForwardSpin());
            this.setRotation(EntityTomahawk.modAngle(this.getRotation() + 180.0f));
        }
    }

    @Override
    protected void onRebounce(MovingObjectPosition mop, double nY, double n, double react) {
        double wZ;
        double wX;
        double w = react * this.getSpinReactFactor() * (double)this.getSpinFactor(true);
        double wH = w * nY / n;
        double wY = w * (double)Utils.sqrt(n * n - nY * nY) / n;
        double r = this.field_70179_y / this.field_70159_w;
        if (!Double.isNaN(r)) {
            wX = wH / (double)Utils.sqrt(1.0 + r * r);
            wZ = r * wX;
        } else {
            wX = (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * wH;
            wZ = (double)MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * wH;
        }
        this.field_70159_w += wX;
        this.field_70181_x += wY;
        this.field_70179_y += wZ;
        if (mop.field_72308_g != null) {
            mop.field_72308_g.field_70159_w -= 0.02 * wX;
            mop.field_72308_g.field_70181_x -= 0.02 * wY;
            mop.field_72308_g.field_70179_y -= 0.02 * wZ;
        }
    }

    @Override
    protected void playHitSound(boolean isStationary, Block block, float hardness) {
        if (!this.field_70170_p.field_72995_K) {
            Block.SoundType sound = TomahawkRegistry.getHitSound(this.getItem().func_77973_b());
            if (sound != null) {
                this.func_85030_a(sound.field_150501_a, sound.func_150497_c(), sound.func_150494_d());
            } else if (hardness < 1.0f) {
                super.playHitSound(isStationary, block, hardness);
            } else {
                sound = block.field_149762_H;
                float vol = sound.func_150497_c() * 28.0f / hardness;
                float pit = sound.func_150494_d() * (1.2f / this.field_70146_Z.nextFloat() * 0.2f + 0.9f) * 2.0f / 5.0f;
                if (!isStationary) {
                    vol /= 6.0f;
                }
                int n = (int)vol;
                for (int i = 0; i < n; ++i) {
                    this.func_85030_a(sound.func_150495_a(), 1.0f, pit);
                }
                this.func_85030_a(sound.func_150495_a(), vol - (float)n, pit);
            }
        }
    }

    protected float getSpinFactor(boolean isSignApplicable) {
        return (this.getAfterHit() >= 0 ? 0.7638889f : (this.func_70241_g() ? 1.1666666f : 1.0f)) * (float)(!isSignApplicable || this.getIsForwardSpin() ? 1 : -1);
    }

    protected float getSpinMotionFactor() {
        return 0.02f;
    }

    protected double getReactFactor() {
        return 0.27;
    }

    protected double getReactFactorOnBlock() {
        return 0.24;
    }

    protected double getSpinReactFactor() {
        return 2.51;
    }

    public static enum PickUpType {
        SURVIVAL,
        CREATIVE,
        ENCH;


        public boolean canBePickedUpBy(PickUpType type) {
            switch (type) {
                case SURVIVAL: {
                    return this == SURVIVAL;
                }
                case CREATIVE: {
                    return this != ENCH;
                }
                case ENCH: {
                    return this != CREATIVE;
                }
            }
            return false;
        }
    }
}

