/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.util;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public abstract class FallbackingMap<K, V>
extends ForwardingMap<K, V>
implements Map<K, V>,
Function<K, V> {
    public static <K, V> FallbackingMap<K, V> create(final Function<K, V> function) {
        final HashMap delegatee = Maps.newHashMap();
        return new FallbackingMap<K, V>(){

            protected Map<K, V> delegate() {
                return delegatee;
            }

            @Override
            public Function<K, V> function() {
                return function;
            }
        };
    }

    protected K castKey(Object key) {
        return (K)key;
    }

    protected abstract Function<K, V> function();

    @Override
    public V put(K key, V value) {
        Object ret = super.put(key, value);
        return (V)(ret != null ? ret : this.function().apply(key));
    }

    @Override
    public V remove(Object key) {
        Object ret = super.remove(key);
        if (ret == null) {
            try {
                ret = this.function().apply(this.castKey(key));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return (V)ret;
    }

    public void set(K key, V value) {
        super.put(key, value);
    }

    public void unset(K key) {
        super.remove(key);
    }

    public V apply(K input) {
        Object ret = super.get(input);
        return (V)(ret != null ? ret : this.function().apply(input));
    }

    @Override
    public V get(Object key) {
        Object ret = super.get(key);
        if (ret == null) {
            try {
                ret = this.function().apply(this.castKey(key));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return (V)ret;
    }
}

