/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.util;

import com.google.common.base.Preconditions;

public class Holder<T> {
    private T reference;

    private Holder() {
    }

    public static <T> Holder<T> absent() {
        return new Holder<T>();
    }

    public static <T> Holder<T> of(T reference) {
        Holder<T> ret = Holder.absent();
        ret.set(reference);
        return ret;
    }

    public static <T> Holder<T> ofNullable(T reference) {
        Holder<T> ret = Holder.absent();
        ret.setNullable(reference);
        return ret;
    }

    public void set(T reference) {
        this.reference = Preconditions.checkNotNull(reference);
    }

    public void clear() {
        this.reference = null;
    }

    public void setNullable(T reference) {
        this.reference = reference;
    }

    public T get() {
        if (this.reference == null) {
            throw new IllegalStateException();
        }
        return this.reference;
    }

    public T orNull() {
        return this.reference;
    }

    public T or(T defaultValue) {
        Preconditions.checkNotNull(defaultValue);
        return this.reference != null ? this.reference : defaultValue;
    }

    public boolean isPresent() {
        return this.reference != null;
    }
}

