/*
 * Decompiled with CFR 0.152.
 */
package zotmc.tomahawk.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Refls {
    private static final Function<Class<?>, String> getClassName = new Function<Class<?>, String>(){

        public String apply(Class<?> input) {
            return input != null ? input.getName() : "null";
        }
    };

    public static Field getDeclaredField(Class<?> clz, String fieldName) {
        try {
            Field ret = clz.getDeclaredField(fieldName);
            ret.setAccessible(true);
            return ret;
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> T get(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Runnable asRunnable(final Object obj, String methodName) {
        final Method method = Refls.getInstanceMethod(obj, methodName, new Class[0]);
        return new Runnable(){

            @Override
            public void run() {
                Refls.invoke(method, obj, new Object[0]);
            }
        };
    }

    public static <T> Supplier<T> asSupplier(final Object obj, String methodName) {
        final Method method = Refls.getInstanceMethod(obj, methodName, new Class[0]);
        return new Supplier<T>(){

            public T get() {
                return Refls.invoke(method, obj, new Object[0]);
            }
        };
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Method getInstanceMethod(Object obj, String name, Class<?> ... parameterTypes) {
        for (Class<?> clz = obj.getClass(); clz != null; clz = clz.getSuperclass()) {
            Method ret = Refls.tryGetDeclaredMethod(clz, name, parameterTypes);
            if (ret == null) continue;
            ret.setAccessible(true);
            return ret;
        }
        throw new RuntimeException(new NoSuchMethodException(String.format("%s.%s(%s)", obj.getClass(), name, Refls.argumentTypesToString(parameterTypes))));
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        return Joiner.on((String)", ").join((Iterable)FluentIterable.from(Arrays.asList(argTypes)).transform(getClassName));
    }

    private static Method getDeclaredMethod(Class<?> clz, String name, Class<?> ... parameterTypes) {
        try {
            return clz.getDeclaredMethod(name, parameterTypes);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Method tryGetDeclaredMethod(Class<?> clz, String name, Class<?> ... parameterTypes) {
        try {
            return clz.getDeclaredMethod(name, parameterTypes);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

