/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.handlers.SeasonTickHandler;
import enhancedbiomes.handlers.VanillaHandler;
import enhancedbiomes.handlers.VillageBlocksHandler;
import enhancedbiomes.handlers.VillageMapHandler;
import enhancedbiomes.proxy.CommonProxy;
import enhancedbiomes.world.WorldTypeEnhancedBiomes;
import enhancedbiomes.world.biome.EnhancedBiomesBiome;
import enhancedbiomes.world.biome.grass.EnhancedBiomesGrass;
import enhancedbiomes.world.biome.grass.plains.EnhancedBiomesPlains;
import enhancedbiomes.world.biome.wasteland.rock.EnhancedBiomesRock;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="enhancedbiomes", name="Enhanced Biomes", version="2.1 for MC 1.7.2", useMetadata=true)
public class EnhancedBiomesMod {
    @SidedProxy(clientSide="enhancedbiomes.proxy.ClientProxy", serverSide="enhancedbiomes.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="SMEZ's Enhanced Biomes Mod")
    public static EnhancedBiomesMod instance;
    public static WorldType enhancedBiomesWorldType;
    public static Block[] rockList;
    public static byte[] rockMetaList;
    public static Block[] woodList;
    public static byte[] woodMetaList;
    public static float[] biomeTempsList;
    public static boolean[] isStoneVillageList;
    public static boolean runBiomeCheck;
    public static boolean worldType;
    public static boolean vanilla;
    public static boolean seasons;
    public static int biomeSize;
    public static int villageDistance;
    public static int villageSize;
    public static int ratioIsland;
    public static int ratioOcean;
    public static int seasonLength;
    public static boolean useNewBlocks;
    public static boolean useVillageMods;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = new File("config/Enhanced Biomes/General.cfg");
        Configuration config = new Configuration(configFile);
        config.load();
        worldType = config.get("general", "Allow world type module", true).getBoolean(true);
        vanilla = config.get("general", "Allow vanilla module", true).getBoolean(true);
        seasons = config.get("general", "Allow seasons module", true).getBoolean(true);
        biomeSize = config.get("general", "Size of biomes in the Enhanced Biomes world types", 4, "Normal is 4, large biomes is 6, but other sizes can be chosen").getInt();
        villageDistance = config.get("general", "Distance between villages in the Enhanced Biomes world types", 32, "Normal is 32").getInt();
        villageSize = config.get("general", "Size of villages in the Enhanced Biomes world types", 0, "Normal is 0").getInt();
        useNewBlocks = config.get("general", "Use new stone", true, "If false, the new stones will not generate instead of regular stone").getBoolean(true);
        useVillageMods = config.get("general", "Enable the modifications to villages", true, "Disabling this will solve issues with other mods which edit the way villages generate").getBoolean(true);
        seasonLength = config.get("general", "Days in each season", 4, "Default is 4").getInt();
        config.save();
        configFile = new File("config/Enhanced Biomes/Oceans.cfg");
        config = new Configuration(configFile);
        config.load();
        ratioIsland = config.get("general", "Ratio of Islands", 3, "Default is 3. This determines the ratio of islands to ocean in the 1/3 of the ocean that they generate in").getInt();
        ratioOcean = config.get("general", "Ratio of Ocean", 5, "Default is 5").getInt();
        config.save();
        if (vanilla) {
            VanillaHandler.config();
        }
        EnhancedBiomesBiome.config();
        if (worldType) {
            enhancedBiomesWorldType = new WorldTypeEnhancedBiomes("typeEB");
        }
        if (vanilla) {
            VanillaHandler.load();
        }
        EnhancedBiomesBlocks.load();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        EnhancedBiomesBiome.load();
        for (int a = 0; a < 256; ++a) {
            if (rockList[a] == null) {
                EnhancedBiomesMod.rockList[a] = EnhancedBiomesMod.getRockForBiome(a);
            }
            if (rockMetaList[a] == 0) {
                EnhancedBiomesMod.rockMetaList[a] = EnhancedBiomesMod.getRockMetaForBiome(a);
            }
            if (woodList[a] == null) {
                EnhancedBiomesMod.woodList[a] = Blocks.field_150344_f;
            }
            EnhancedBiomesMod.biomeTempsList[a] = BiomeGenBase.func_150565_n()[a] != null ? BiomeGenBase.func_150565_n()[a].field_76750_F : 0.5f;
        }
        if (useVillageMods) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new VillageMapHandler());
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new VillageBlocksHandler());
        }
        if (seasons) {
            FMLCommonHandler.instance().bus().register((Object)new SeasonTickHandler());
        }
        if (runBiomeCheck) {
            for (int x = 0; x < 256; ++x) {
                if (BiomeGenBase.func_150565_n()[x] == null) continue;
                BiomeGenBase biome = BiomeGenBase.func_150565_n()[x];
                Block top = null;
                if (biome.field_76752_A != null) {
                    top = biome.field_76752_A;
                }
                Block filler = null;
                if (biome.field_76753_B != null) {
                    filler = biome.field_76753_B;
                }
                System.out.println(x + ": " + biome.field_76791_y);
                System.out.println("Height: " + biome.field_76748_D + ", " + biome.field_76749_E);
                System.out.println("Temperature: " + biome.field_76750_F);
                System.out.println("Rainfall: " + biome.field_76751_G);
                if (top != null) {
                    System.out.println("Top block: " + top.func_149732_F());
                }
                if (filler != null) {
                    System.out.println("Filler block: " + filler.func_149732_F());
                }
                System.out.print("Biome Types: ");
                for (int a = 0; a < BiomeDictionary.getTypesForBiome((BiomeGenBase)biome).length; ++a) {
                    System.out.print(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)[a].toString() + ", ");
                }
                System.out.println();
            }
            Object biome = null;
            System.out.print(biome.field_76756_M);
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static Block getRockForBiome(int id) {
        if (!useNewBlocks) {
            return Blocks.field_150348_b;
        }
        if (BiomeGenBase.func_150565_n()[id] == null) {
            return Blocks.field_150348_b;
        }
        if (id == EnhancedBiomesRock.biomeVolcano.field_76756_M || id == BiomeGenBase.field_76771_b.field_76756_M) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (id == BiomeGenBase.field_76781_i.field_76756_M || id == EnhancedBiomesBiome.biomeRiparian.field_76756_M) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (id == BiomeGenBase.field_150588_X.field_76756_M) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (id == EnhancedBiomesPlains.biomeSavannah.field_76756_M) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (id == EnhancedBiomesGrass.biomeMountainTundra.field_76756_M) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            return EnhancedBiomesBlocks.stoneEB;
        }
        return Blocks.field_150348_b;
    }

    public static byte getRockMetaForBiome(int id) {
        if (!useNewBlocks) {
            return 0;
        }
        if (BiomeGenBase.func_150565_n()[id] == null) {
            return 0;
        }
        if (id == EnhancedBiomesRock.biomeVolcano.field_76756_M || id == BiomeGenBase.field_76771_b.field_76756_M) {
            return 0;
        }
        if (id == BiomeGenBase.field_76781_i.field_76756_M || id == EnhancedBiomesBiome.biomeRiparian.field_76756_M) {
            return 3;
        }
        if (id == BiomeGenBase.field_150588_X.field_76756_M) {
            return 5;
        }
        if (id == EnhancedBiomesPlains.biomeSavannah.field_76756_M) {
            return 2;
        }
        if (id == EnhancedBiomesGrass.biomeMountainTundra.field_76756_M) {
            return 5;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 1;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            return 2;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 4;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            return 5;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[id], (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            return 3;
        }
        return 0;
    }

    public static boolean isValidIslandBiome(BiomeGenBase biome) {
        if (biome.field_76748_D >= 0.2f) {
            return true;
        }
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
    }

    public static float getTideHeight(long time) {
        float r = 63.5f;
        r = (time %= 24000L) <= 6000L ? (float)(63.5 + (double)((int)(time / 500L)) * 0.125) : (time <= 18000L ? (float)(65.0 - (double)((int)((time - 6000L) / 500L)) * 0.125) : (float)(62.0 + (double)((int)((time - 18000L) / 500L)) * 0.125));
        return r;
    }

    static {
        rockList = new Block[256];
        rockMetaList = new byte[256];
        woodList = new Block[256];
        woodMetaList = new byte[256];
        biomeTempsList = new float[256];
        isStoneVillageList = new boolean[256];
        runBiomeCheck = false;
    }
}

