/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import enhancedbiomes.EnhancedBiomesMod;
import enhancedbiomes.handlers.SeasonTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class EnhancedBiomesGUIDisplay
extends Gui {
    private Minecraft mc;

    public EnhancedBiomesGUIDisplay(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!this.mc.field_71439_g.getEntityData().func_74767_n("biomeInfoDisplay")) {
            return;
        }
        int pos = this.mc.field_71439_g.getEntityData().func_74762_e("biomeInfoPos");
        BiomeGenBase currentBiome = this.mc.field_71441_e.func_72807_a((int)this.mc.field_71439_g.field_70165_t, (int)this.mc.field_71439_g.field_70161_v);
        ScaledResolution res = new ScaledResolution(this.mc.field_71474_y, this.mc.field_71443_c, this.mc.field_71440_d);
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        String nameid = "Biome: " + currentBiome.field_76791_y + ", ID: " + currentBiome.field_76756_M;
        String top = "Top Block: " + currentBiome.field_76752_A.func_149732_F();
        String filler = "Filler Block: " + currentBiome.field_76753_B.func_149732_F();
        String temp = "Temperature: " + currentBiome.field_76750_F;
        String rootvar = "Terrain Type: " + EnhancedBiomesGUIDisplay.getHeightDesc(currentBiome.field_76748_D, currentBiome.field_76749_E) + ", " + EnhancedBiomesGUIDisplay.getHillDesc(currentBiome.field_76748_D, currentBiome.field_76749_E);
        EntityClientPlayerMP player = this.mc.field_71439_g;
        String xyz = "X: " + (int)player.field_70165_t + "  Y: " + (int)player.field_70163_u + "  Z: " + (int)player.field_70161_v;
        String season = SeasonTickHandler.season == 0 ? "Spring" : (SeasonTickHandler.season == 1 ? "Summer" : (SeasonTickHandler.season == 2 ? "Autumn" : (SeasonTickHandler.season == 3 ? "Winter" : "Null")));
        String tideHeight = "Tide Height: " + EnhancedBiomesMod.getTideHeight(this.mc.field_71441_e.func_72820_D());
        switch (pos) {
            case 0: {
                this.func_73731_b(this.mc.field_71466_p, nameid, 2, 2, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, top, 2, 12, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, filler, 2, 22, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, temp, 2, 32, EnhancedBiomesGUIDisplay.getColourForTemp(currentBiome.field_76750_F));
                this.func_73731_b(this.mc.field_71466_p, rootvar, 2, 42, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, xyz, 2, 52, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, season, 2, 62, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, tideHeight, 2, 72, 0xFFFFFF);
                break;
            }
            case 1: {
                this.func_73731_b(this.mc.field_71466_p, nameid, width - this.mc.field_71466_p.func_78256_a(nameid) - 2, 2, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, top, width - this.mc.field_71466_p.func_78256_a(top) - 2, 12, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, filler, width - this.mc.field_71466_p.func_78256_a(filler) - 2, 22, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, temp, width - this.mc.field_71466_p.func_78256_a(temp) - 2, 32, EnhancedBiomesGUIDisplay.getColourForTemp(currentBiome.field_76750_F));
                this.func_73731_b(this.mc.field_71466_p, rootvar, width - this.mc.field_71466_p.func_78256_a(rootvar) - 2, 42, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, xyz, width - this.mc.field_71466_p.func_78256_a(xyz) - 2, 52, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, season, width - this.mc.field_71466_p.func_78256_a(season) - 2, 62, 0xFFFFFF);
                break;
            }
            case 2: {
                this.func_73731_b(this.mc.field_71466_p, nameid, 2, height - 70, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, top, 2, height - 60, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, filler, 2, height - 50, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, temp, 2, height - 40, EnhancedBiomesGUIDisplay.getColourForTemp(currentBiome.field_76750_F));
                this.func_73731_b(this.mc.field_71466_p, rootvar, 2, height - 30, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, xyz, 2, height - 20, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, season, 2, height - 10, 0xFFFFFF);
                break;
            }
            case 3: {
                this.func_73731_b(this.mc.field_71466_p, nameid, width - this.mc.field_71466_p.func_78256_a(nameid) - 2, height - 70, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, top, width - this.mc.field_71466_p.func_78256_a(top) - 2, height - 60, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, filler, width - this.mc.field_71466_p.func_78256_a(filler) - 2, height - 50, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, temp, width - this.mc.field_71466_p.func_78256_a(temp) - 2, height - 40, EnhancedBiomesGUIDisplay.getColourForTemp(currentBiome.field_76750_F));
                this.func_73731_b(this.mc.field_71466_p, rootvar, width - this.mc.field_71466_p.func_78256_a(rootvar) - 2, height - 30, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, xyz, width - this.mc.field_71466_p.func_78256_a(xyz) - 2, height - 20, 0xFFFFFF);
                this.func_73731_b(this.mc.field_71466_p, season, width - this.mc.field_71466_p.func_78256_a(season) - 2, height - 10, 0xFFFFFF);
            }
        }
    }

    public static int getColourForTemp(float temp) {
        return (double)temp < 0.2 ? 345059 : ((double)temp < 0.4 ? 360518 : ((double)temp < 1.0 ? 0xFAA00F : 0xFF0000));
    }

    public static String getHeightDesc(float root, float var) {
        if (root <= -0.8f) {
            return "Oceanic";
        }
        if (root <= 0.0f) {
            return "Wetland";
        }
        if (root <= 0.4f) {
            return "Low";
        }
        if (root <= 1.0f) {
            return "Medium";
        }
        if (root <= 1.5f) {
            return "High";
        }
        return "Alpine";
    }

    public static String getHillDesc(float root, float var) {
        if (var <= 0.2f) {
            return "Flat";
        }
        if (var <= 0.5f) {
            return "Hills";
        }
        if (var <= 0.8f) {
            return "Mountainous";
        }
        return "Sheer";
    }
}

