/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes.world.biome.wetland;

import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.helpers.BiomeGenManager;
import enhancedbiomes.helpers.BiomeWoods;
import enhancedbiomes.helpers.EBHeights;
import enhancedbiomes.world.biome.BiomeGenWetlandBase;
import enhancedbiomes.world.biome.BiomeGenWoodlandBase;
import enhancedbiomes.world.biome.wetland.BiomeGenCarr;
import enhancedbiomes.world.biome.wetland.BiomeGenEphemeralLake;
import enhancedbiomes.world.biome.wetland.BiomeGenFen;
import enhancedbiomes.world.biome.wetland.BiomeGenLake;
import enhancedbiomes.world.biome.wetland.BiomeGenMangrove;
import enhancedbiomes.world.biome.wetland.BiomeGenMarsh;
import enhancedbiomes.world.biome.woodland.BiomeGenWoodlands;
import java.io.File;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.config.Configuration;

public class EnhancedBiomesWetland {
    public static int mangroveId;
    public static int mangroveGen;
    public static boolean villageMangrove;
    public static BiomeGenWetlandBase biomeMangrove;
    public static int ephemeralLakeId;
    public static int ephemeralLakeGen;
    public static boolean villageEphemeralLake;
    public static BiomeGenWetlandBase biomeEphemeralLake;
    public static int ephemeralLakeEdgeId;
    public static boolean villageEphemeralLakeEdge;
    public static BiomeGenWetlandBase biomeEphemeralLakeEdge;
    public static int fenId;
    public static int fenGen;
    public static boolean villageFen;
    public static BiomeGenWetlandBase biomeFen;
    public static int carrId;
    public static int carrGen;
    public static boolean villageCarr;
    public static BiomeGenWetlandBase biomeCarr;
    public static int lakeId;
    public static boolean villageLake;
    public static BiomeGenWetlandBase biomeLake;
    public static int woodlandLakeId;
    public static boolean villageWoodlandLake;
    public static BiomeGenWoodlandBase biomeWoodlandLake;
    public static int woodlandLakeEdgeId;
    public static boolean villageWoodlandLakeEdge;
    public static BiomeGenWoodlandBase biomeWoodlandLakeEdge;
    public static int marshId;
    public static int marshGen;
    public static boolean villageMarsh;
    public static BiomeGenWetlandBase biomeMarsh;

    public static void config() {
        File configFile = new File("config/Enhanced Biomes/Biomes.cfg");
        Configuration config = new Configuration(configFile);
        config.load();
        mangroveId = config.get("general", "Biome ID of Mangrove", 87).getInt();
        mangroveGen = config.get("general", "Generation frequency of Mangrove biome", 1).getInt();
        villageMangrove = config.get("general", "Generate villages in Mangrove biome", true).getBoolean(true);
        ephemeralLakeId = config.get("general", "Biome ID of Ephemeral Lake", 88).getInt();
        ephemeralLakeGen = config.get("general", "Generation frequency of Ephemeral Lake biome", 1).getInt();
        villageEphemeralLake = config.get("general", "Generate villages in Ephemeral Lake biome", true).getBoolean(true);
        ephemeralLakeEdgeId = config.get("general", "Biome ID of Ephemeral Lake Edge", 89).getInt();
        villageEphemeralLakeEdge = config.get("general", "Generate villages in Ephemeral Lake Edge biome", true).getBoolean(true);
        fenId = config.get("general", "Biome ID of Fens", 90).getInt();
        fenGen = config.get("general", "Generation frequency of Fens biome", 1).getInt();
        villageFen = config.get("general", "Generate villages in Fens biome", true).getBoolean(true);
        carrId = config.get("general", "Biome ID of Carr", 91).getInt();
        carrGen = config.get("general", "Generation frequency of Carr biome", 1).getInt();
        villageCarr = config.get("general", "Generate villages in Carr biome", true).getBoolean(true);
        lakeId = config.get("general", "Biome ID of Lake", 100).getInt();
        villageLake = config.get("general", "Generate villages in Lake biome", false).getBoolean(true);
        woodlandLakeId = config.get("general", "Biome ID of Woodland Lake", 216).getInt();
        villageWoodlandLake = config.get("general", "Generate villages in Woodland Lake biome", true).getBoolean(true);
        woodlandLakeEdgeId = config.get("general", "Biome ID of Woodland Lake Edge", 217).getInt();
        villageWoodlandLakeEdge = config.get("general", "Generate villages in Woodland Lake Edge biome", true).getBoolean(true);
        marshId = config.get("general", "Biome ID of Marsh", 102).getInt();
        marshGen = config.get("general", "Generation frequency of Marsh biome", 1).getInt();
        villageMarsh = config.get("general", "Generate villages in Marsh biome", true).getBoolean(true);
        config.save();
    }

    public static void load() {
        biomeMangrove = (BiomeGenWetlandBase)new BiomeGenMangrove(mangroveId).func_76739_b(5470985).func_76733_a(5470985).func_76732_a(0.9f, 0.6f).func_150570_a(EBHeights.heightPartiallySubmerged).func_76735_a("Mangroves");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeMangrove, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
        BiomeGenManager.addWarmBiome(biomeMangrove, mangroveGen);
        if (villageMangrove) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeMangrove, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeMangrove);
        BiomeWoods.register(biomeMangrove, EnhancedBiomesBlocks.planksEB, 3);
        biomeEphemeralLake = (BiomeGenWetlandBase)new BiomeGenEphemeralLake(ephemeralLakeId).func_76739_b(0x606060).func_76733_a(5470985).func_76732_a(0.5f, 0.9f).func_150570_a(EBHeights.heightPartiallySubmerged).func_76735_a("Ephemeral Lake");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeEphemeralLake, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER, BiomeDictionary.Type.BEACH});
        BiomeGenManager.addWarmBiome(biomeEphemeralLake, ephemeralLakeGen);
        if (villageEphemeralLake) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeEphemeralLake, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeEphemeralLake);
        BiomeWoods.register(biomeEphemeralLake, EnhancedBiomesBlocks.planksEB, 13);
        biomeEphemeralLakeEdge = (BiomeGenWetlandBase)new BiomeGenEphemeralLake(ephemeralLakeEdgeId).func_76739_b(0x606060).func_76733_a(5470985).func_76732_a(0.5f, 0.9f).func_150570_a(EBHeights.heightShores).func_76735_a("Ephemeral Lake Edge");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeEphemeralLakeEdge, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER, BiomeDictionary.Type.BEACH});
        if (villageEphemeralLakeEdge) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeEphemeralLakeEdge, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeEphemeralLakeEdge);
        BiomeWoods.register(biomeEphemeralLakeEdge, EnhancedBiomesBlocks.planksEB, 13);
        biomeFen = (BiomeGenWetlandBase)new BiomeGenFen(fenId).func_76739_b(5470985).func_76733_a(5470985).func_76732_a(0.2f, 0.8f).func_150570_a(EBHeights.heightPartiallySubmerged).func_76735_a("Fens");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeFen, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
        BiomeGenManager.addCoolBiome(biomeFen, fenGen);
        if (villageFen) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeFen, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeFen);
        BiomeWoods.register(biomeFen, EnhancedBiomesBlocks.planksEB, 3);
        biomeCarr = (BiomeGenWetlandBase)new BiomeGenCarr(carrId).func_76739_b(5470985).func_76733_a(5470985).func_76732_a(0.25f, 0.8f).func_150570_a(EBHeights.heightPartiallySubmerged).func_76735_a("Carr");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeCarr, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
        BiomeGenManager.addCoolBiome(biomeCarr, carrGen);
        if (villageCarr) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeCarr, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeCarr);
        BiomeWoods.register(biomeCarr, EnhancedBiomesBlocks.planksEB, 8);
        biomeLake = (BiomeGenWetlandBase)new BiomeGenLake(lakeId).func_76739_b(0x606060).func_76733_a(5470985).func_76732_a(0.6f, 0.8f).func_150570_a(EBHeights.heightShallowWaters).func_76735_a("Lake");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeLake, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER});
        if (villageLake) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeLake, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeLake);
        BiomeWoods.register(biomeLake, EnhancedBiomesBlocks.planksEB, 8);
        biomeWoodlandLake = (BiomeGenWoodlandBase)new BiomeGenWoodlands(woodlandLakeId).func_76739_b(0x606060).func_76733_a(5470985).func_76732_a(0.5f, 0.9f).func_150570_a(EBHeights.heightPartiallySubmerged).func_76735_a("Woodland Lake");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeWoodlandLake, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER, BiomeDictionary.Type.BEACH});
        if (villageWoodlandLake) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeWoodlandLake, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeWoodlandLake);
        BiomeWoods.register(biomeWoodlandLake, Blocks.field_150344_f, 0);
        biomeWoodlandLakeEdge = (BiomeGenWoodlandBase)new BiomeGenWoodlands(woodlandLakeEdgeId).func_76739_b(0x606060).func_76733_a(5470985).func_76732_a(0.5f, 0.9f).func_150570_a(EBHeights.heightShores).func_76735_a("Woodland Lake Edge");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeWoodlandLakeEdge, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER, BiomeDictionary.Type.BEACH});
        if (villageWoodlandLakeEdge) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeWoodlandLakeEdge, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeWoodlandLakeEdge);
        BiomeWoods.register(biomeWoodlandLakeEdge, Blocks.field_150344_f, 0);
        biomeMarsh = (BiomeGenWetlandBase)new BiomeGenMarsh(marshId).func_76739_b(5470985).func_76733_a(5470985).func_76732_a(0.9f, 0.6f).func_150570_a(EBHeights.heightLowPlains).func_76735_a("Marsh");
        BiomeDictionary.registerBiomeType((BiomeGenBase)biomeMarsh, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
        BiomeGenManager.addWarmBiome(biomeMarsh, marshGen);
        if (villageMarsh) {
            BiomeManager.addVillageBiome((BiomeGenBase)biomeMarsh, (boolean)true);
        }
        BiomeManager.addStrongholdBiome((BiomeGenBase)biomeMarsh);
        BiomeWoods.register(biomeMarsh, Blocks.field_150344_f, 0);
    }
}

