/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes.world.gen.geometry;

import enhancedbiomes.helpers.EnhancedBiomesWorldHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenEllipsoid
extends WorldGenerator {
    Block fillId = Blocks.field_150350_a;
    int radius;
    boolean exception = false;
    Block exceptionID = Blocks.field_150350_a;
    int fillMeta = 0;
    float variation = 1.0f;

    public WorldGenEllipsoid(Block fill, int radius, float variation) {
        this.fillId = fill;
        this.radius = radius;
        this.variation = variation;
    }

    public WorldGenEllipsoid(Block fill, int radius, float variation, int meta) {
        this.fillId = fill;
        this.radius = radius;
        this.fillMeta = meta;
        this.variation = variation;
    }

    public WorldGenEllipsoid(Block fill, int radius, float variation, boolean exception, Block exceptionID) {
        this.fillId = fill;
        this.radius = radius;
        this.exception = exception;
        this.exceptionID = exceptionID;
        this.variation = variation;
    }

    public boolean func_76484_a(World par1World, Random par2Random, int x, int y, int z) {
        int baseX = x;
        int baseY = y;
        int baseZ = z;
        int radiusSq = this.radius * this.radius;
        for (int posX = -this.radius; posX <= this.radius; ++posX) {
            int posY = -this.radius;
            while ((float)posY <= (float)this.radius * this.variation) {
                for (int posZ = -this.radius; posZ <= this.radius; ++posZ) {
                    int distance = (int)((float)(posX * posX) + (float)(posY * posY) / this.variation / this.variation + (float)(posZ * posZ));
                    if (distance > radiusSq || this.exception && par1World.func_147439_a(posX + baseX, posY + baseY, posZ + baseZ) == this.exceptionID) continue;
                    if (this.fillId instanceof BlockLeavesBase) {
                        EnhancedBiomesWorldHelper.setBlockIfEmpty(posX + baseX, posY + baseY, posZ + baseZ, this.fillId, this.fillMeta, 3, par1World);
                        continue;
                    }
                    par1World.func_147465_d(posX + baseX, posY + baseY, posZ + baseZ, this.fillId, this.fillMeta, 3);
                }
                ++posY;
            }
        }
        return true;
    }
}

