/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.block;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import plantmegapack.api.PMPPlantCategory;
import plantmegapack.bin.PMPBlockPlant;
import plantmegapack.bin.PMPRenderers;
import plantmegapack.item.PMPItemBamboo;

public class PMPBlockBamboo
extends PMPBlockPlant {
    private int renderStyle;

    public PMPBlockBamboo(String blockName, int invIconIndex, int renderStyle, int maxHeight) {
        super(PMPPlantCategory.bamboo, blockName, 5, invIconIndex, false);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149766_f);
        GameRegistry.registerBlock((Block)this, PMPItemBamboo.class, (String)blockName);
        this.renderStyle = renderStyle;
        this.heightLimit = maxHeight > 0 && maxHeight < 31 ? maxHeight : 10;
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.2f), (double)y, (double)((float)z + 0.2f), (double)((float)x + 0.8f), (double)((float)y + 1.0f), (double)((float)z + 0.8f));
    }

    @Override
    public int func_149645_b() {
        return PMPRenderers.renderBambooID;
    }

    @Override
    public boolean canPlantOnThisBlock(Block block) {
        return super.canPlantOnThisBlock(block) || this == block;
    }

    @Override
    public boolean func_149742_c(World world, int x, int y, int z) {
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (this == blockBelow) {
            return PMPBlockPlant.getPlantHeightFromTop(world, x, y - 1, z) < this.heightLimit;
        }
        return super.func_149742_c(world, x, y, z);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metaData) {
        return 4;
    }

    public void func_149714_e(World world, int x, int y, int z, int metaData) {
        Block blockBelow;
        Block block = world.func_147439_a(x, y, z);
        if (block == (blockBelow = world.func_147439_a(x, y - 1, z))) {
            switch (this.renderStyle) {
                case 0: 
                case 1: {
                    this.updateBambooFromTop(world, x, y, z);
                    break;
                }
                case 2: {
                    world.func_72921_c(x, y - 1, z, world.field_73012_v.nextInt(4), 2);
                }
            }
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int metaData) {
        Block blockBelow;
        Block block = world.func_147439_a(x, y, z);
        if (block == (blockBelow = world.func_147439_a(x, y - 1, z))) {
            world.func_72921_c(x, y - 1, z, 4, 2);
            if (this.renderStyle == 1) {
                this.updateBambooFromTop(world, x, y - 1, z);
            }
        }
    }

    @Override
    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        Block blockBelow;
        Block block = world.func_147439_a(x, y, z);
        if (block == (blockBelow = world.func_147439_a(x, y - 1, z))) {
            return world.func_72805_g(x, y, z);
        }
        return 4;
    }

    public int getRenderStyle() {
        return this.renderStyle;
    }

    public void updateBambooFromTop(World world, int x, int y, int z) {
        int currentHeight = y;
        int count = PMPBlockPlant.getPlantHeightFromTop(world, x, y, z);
        int icon = 4;
        while (count > 0) {
            --count;
            --currentHeight;
            if (icon > 0) {
                switch (this.renderStyle) {
                    default: {
                        --icon;
                        break;
                    }
                    case 1: {
                        if (count > 3) {
                            icon = 3;
                            break;
                        }
                        --icon;
                        break;
                    }
                    case 2: {
                        icon = 1 + world.field_73012_v.nextInt(3);
                    }
                }
            }
            world.func_72921_c(x, currentHeight, z, icon, 2);
        }
    }

    public boolean growBambooPlantFromBottom(World world, int x, int y, int z) {
        int currentHeight = PMPBlockPlant.getPlantHeightFromBase(world, x, y, z);
        if (currentHeight >= this.getHeightLimit() || !world.func_147437_c(x, y + currentHeight, z)) {
            return false;
        }
        world.func_147465_d(x, y + currentHeight, z, (Block)this, 4, 2);
        this.updateBambooFromTop(world, x, y + currentHeight, z);
        return true;
    }
}

