/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.oredict.OreDictionary;
import plantmegapack.bin.PMPBlockPlant;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.block.PMPBlockFlowerMulti;

public abstract class PMPGenBase {
    public static boolean placePlant(World world, Random random, int x, int y, int z, Block block, int metaData) {
        Block blockSoil = world.func_147439_a(x, y - 1, z);
        if (!PMPGenBase.canReplaceBlockWithPlant(world, x, y, z) || !PMPGenBase.isSoilBlock(blockSoil)) {
            return false;
        }
        return PMPGenBase.spawnSinglePlant(world, random, x, y, z, block, metaData);
    }

    public static boolean placeSandPlant(World world, Random random, int x, int y, int z, Block block, int metaData) {
        Block blockSoil = world.func_147439_a(x, y - 1, z);
        if (!PMPGenBase.canReplaceBlockWithPlant(world, x, y, z) || !PMPGenBase.isSandBlock(blockSoil)) {
            return false;
        }
        return PMPGenBase.spawnSinglePlant(world, random, x, y, z, block, metaData);
    }

    public static boolean placeUnderwaterPlant(World world, Random random, int x, int y, int z, Block block, int metaData) {
        Block blockSpawn = world.func_147439_a(x, y, z);
        Block blockSoil = world.func_147439_a(x, y - 1, z);
        if (blockSpawn != Blocks.field_150355_j || !PMPGenBase.isWaterPlantSoilBlock(blockSoil)) {
            return false;
        }
        return PMPGenBase.spawnSinglePlant(world, random, x, y, z, block, metaData);
    }

    public static boolean spawnSinglePlant(World world, Random random, int x, int y, int z, Block block, int metaData) {
        if (metaData == -1) {
            int growthStages = ((PMPBlockPlant)block).getGrowthStages();
            int spawnStage = random.nextInt(growthStages);
            if (((PMPBlockPlant)block).isTallPlant()) {
                if (spawnStage > 1) {
                    switch (spawnStage) {
                        case 2: {
                            world.func_147465_d(x, y, z, block, 2, 2);
                            world.func_147465_d(x, y + 1, z, block, 3, 2);
                            return true;
                        }
                        case 3: {
                            world.func_147465_d(x, y, z, block, 4, 2);
                            world.func_147465_d(x, y + 1, z, block, 5, 2);
                            return true;
                        }
                        case 4: {
                            world.func_147465_d(x, y, z, block, 6, 2);
                            world.func_147465_d(x, y + 1, z, block, 7, 2);
                            return true;
                        }
                    }
                    return false;
                }
                world.func_147465_d(x, y, z, block, spawnStage, 2);
                return true;
            }
            world.func_147465_d(x, y, z, block, spawnStage, 2);
            return true;
        }
        world.func_147465_d(x, y, z, block, metaData, 2);
        return true;
    }

    public static int adjustHeightForLeaf(World world, Random random, int x, int y, int z) {
        int maxHeight = -1;
        boolean canContinueDown = true;
        do {
            if (!PMPGenBase.isSoilBlock(world, x, --y - 1, z)) continue;
            canContinueDown = false;
        } while (canContinueDown && y > 0);
        return y;
    }

    public static boolean placeWaterPlant(World world, PMPSpawnLocation locationData, Block block) {
        if (locationData.blockSpawn == Blocks.field_150355_j) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, block, 0, 2);
            return true;
        }
        return false;
    }

    public static boolean isAdjacentToBlock(World world, int x, int y, int z, Block block) {
        return world.func_147439_a(x - 1, y, z) == block || world.func_147439_a(x - 1, y, z - 1) == block || world.func_147439_a(x - 1, y, z + 1) == block || world.func_147439_a(x, y, z - 1) == block || world.func_147439_a(x, y, z + 1) == block || world.func_147439_a(x + 1, y, z) == block || world.func_147439_a(x + 1, y, z - 1) == block || world.func_147439_a(x + 1, y, z + 1) == block;
    }

    public static boolean isAdjacentToBlock2(World world, int x, int y, int z, Block block) {
        return world.func_147439_a(x - 2, y, z - 2) == block || world.func_147439_a(x - 1, y, z - 2) == block || world.func_147439_a(x, y, z - 2) == block || world.func_147439_a(x + 1, y, z - 2) == block || world.func_147439_a(x + 2, y, z - 2) == block || world.func_147439_a(x - 2, y, z - 1) == block || world.func_147439_a(x - 2, y, z) == block || world.func_147439_a(x - 2, y, z + 1) == block || world.func_147439_a(x - 2, y, z + 2) == block || world.func_147439_a(x - 1, y, z + 2) == block || world.func_147439_a(x, y, z + 2) == block || world.func_147439_a(x + 1, y, z + 2) == block || world.func_147439_a(x + 2, y, z + 2) == block || world.func_147439_a(x + 2, y, z + 2) == block || world.func_147439_a(x + 2, y, z + 1) == block || world.func_147439_a(x + 2, y, z) == block || world.func_147439_a(x + 2, y, z - 1) == block;
    }

    public static int isAdjacentToLogBlock(World world, int x, int y, int z) {
        if (PMPGenBase.isLogBlock(world, x, y, z - 1)) {
            return 3;
        }
        if (PMPGenBase.isLogBlock(world, x - 1, y, z)) {
            return 5;
        }
        if (PMPGenBase.isLogBlock(world, x + 1, y, z)) {
            return 4;
        }
        if (PMPGenBase.isLogBlock(world, x, y, z + 1)) {
            return 2;
        }
        return 0;
    }

    public static boolean isSurroundedByBlock(World world, int x, int y, int z, Block block) {
        return world.func_147439_a(x - 1, y, z) == block && world.func_147439_a(x - 1, y, z - 1) == block && world.func_147439_a(x - 1, y, z + 1) == block && world.func_147439_a(x, y, z - 1) == block && world.func_147439_a(x, y, z + 1) == block && world.func_147439_a(x + 1, y, z) == block && world.func_147439_a(x + 1, y, z - 1) == block && world.func_147439_a(x + 1, y, z + 1) == block;
    }

    public static boolean isAdjacentToDifferentBiome(BiomeGenBase biome, World world, int x, int y, int z) {
        BiomeGenBase biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z - 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z + 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x, z - 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x, z + 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z - 1);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z);
        if (biome != biomeCompare) {
            return true;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z + 1);
        return biome != biomeCompare;
    }

    public static BiomeGenBase checkForNearDifferentBiome(BiomeGenBase biome, World world, int x, int y, int z) {
        BiomeGenBase biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z - 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z - 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 2, z - 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 2, z - 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 2, z + 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 2, z + 1);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x - 1, z + 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        biomeCompare = world.getBiomeGenForCoordsBody(x + 1, z + 2);
        if (biome != biomeCompare) {
            return biomeCompare;
        }
        return null;
    }

    public static boolean generateUnderwaterPlantCluster(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int ix = x + random.nextInt(range) - random.nextInt(range);
            int iz = z + random.nextInt(range) - random.nextInt(range);
            int iy = world.func_72976_f(ix, iz);
            int height = PMPGenBase.adjustLocationForWaterBlock(world, ix, iy, iz);
            Block blockAbove = world.func_147439_a(ix, (iy -= height) + 1, iz);
            if (!PMPGenBase.canGrowOceanPlantHere(world, ix, iy, iz) || blockAbove != Blocks.field_150355_j && blockAbove.func_149688_o() != Material.field_151586_h) continue;
            PMPGenBase.placePlant(world, random, ix, iy, iz, block, -1);
        }
        return true;
    }

    public static void generateRandomPlantCluster(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int iz;
            int iy;
            int ix = x + random.nextInt(range) - random.nextInt(range);
            if (PMPGenBase.isLeafBlock(world, ix, (iy = world.func_72976_f(ix, iz = z + random.nextInt(range) - random.nextInt(range))) - 1, iz)) {
                iy = PMPGenBase.adjustHeightForLeaf(world, random, ix, iy, iz);
            }
            PMPGenBase.placePlant(world, random, ix, iy, iz, block, -1);
        }
    }

    public static void generateRandomSandPlantCluster(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int ix = x + random.nextInt(range) - random.nextInt(range);
            int iz = z + random.nextInt(range) - random.nextInt(range);
            int iy = world.func_72976_f(ix, iz);
            PMPGenBase.placeSandPlant(world, random, ix, iy, iz, block, -1);
        }
    }

    public static void generateRandomPlantClusterAtSameHeight(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants) {
        int iy = y;
        for (int count = 0; count < maxPlants; ++count) {
            int ix = x + random.nextInt(range) - random.nextInt(range);
            int iz = z + random.nextInt(range) - random.nextInt(range);
            PMPGenBase.placePlant(world, random, ix, iy, iz, block, -1);
        }
    }

    public static void generateRandomGrassCluster(World world, Random random, int x, int y, int z, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int ix = x + random.nextInt(range) - random.nextInt(range);
            int iz = z + random.nextInt(range) - random.nextInt(range);
            int iy = world.func_72976_f(ix, iz);
            PMPGenBase.placePlant(world, random, ix, iy, iz, (Block)Blocks.field_150329_H, 1);
        }
    }

    public static void generateRandomMultiFlowerCluster(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int ix = x + random.nextInt(range) - random.nextInt(range);
            int iz = z + random.nextInt(range) - random.nextInt(range);
            int iy = world.func_72976_f(ix, iz);
            Block blockSoil = world.func_147439_a(ix, iy - 1, iz);
            if (PMPGenBase.isLeafBlock(world, ix, iy - 1, iz)) {
                iy = PMPGenBase.adjustHeightForLeaf(world, random, ix, iy, iz);
            }
            if (!PMPGenBase.canReplaceBlockWithPlant(world, ix, iy, iz) || !((PMPBlockFlowerMulti)block).canPlantOnThisBlock(blockSoil)) continue;
            world.func_147465_d(ix, iy, iz, block, random.nextInt(((PMPBlockFlowerMulti)block).getFlowerColorCount()), 2);
        }
    }

    public static int adjustLocationForWaterBlock(World world, int x, int y, int z) {
        int startHeight = y;
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        while (blockBelow == Blocks.field_150355_j || blockBelow.func_149688_o() == Material.field_151586_h) {
            blockBelow = world.func_147439_a(x, --y - 1, z);
        }
        return startHeight - y;
    }

    public static void surroundPlantWithGrass(World world, int x, int y, int z) {
        int ix = x - 1;
        int iy = y;
        int iz = z - 1;
        if (Blocks.field_150329_H.func_149742_c(world, ix, iy, iz)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x, iy, iz = z - 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x + 1, iy, iz = z - 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x - 1, iy, iz = z)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x + 1, iy, iz = z)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x - 1, iy, iz = z + 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x, iy, iz = z + 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
        if (Blocks.field_150329_H.func_149742_c(world, ix = x + 1, iy, iz = z + 1)) {
            world.func_147465_d(ix, iy, iz, (Block)Blocks.field_150329_H, 1, 2);
        }
    }

    public static boolean checkAndAdjustSpawnForBlock(World world, PMPSpawnLocation locationData, Block block, int heightModifier) {
        int ix = locationData.x - 1;
        int iy = locationData.y + heightModifier;
        int iz = locationData.z - 1;
        Block blockPotential = world.func_147439_a(ix, iy, iz);
        boolean blockFound = false;
        boolean bl = blockFound = block == blockPotential;
        if (!blockFound) {
            ix = locationData.x;
            iz = locationData.z - 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl2 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x + 1;
            iz = locationData.z - 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl3 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x - 1;
            iz = locationData.z;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl4 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x + 1;
            iz = locationData.z;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl5 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x - 1;
            iz = locationData.z + 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl6 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x;
            iz = locationData.z + 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl7 = blockFound = block == blockPotential;
        }
        if (!blockFound) {
            ix = locationData.x + 1;
            iz = locationData.z + 1;
            blockPotential = world.func_147439_a(ix, iy, iz);
            boolean bl8 = blockFound = block == blockPotential;
        }
        if (blockFound) {
            locationData.x = ix;
            locationData.y = iy;
            locationData.z = iz;
            return true;
        }
        return false;
    }

    public static boolean canGrowOceanPlantHere(World world, int x, int y, int z) {
        Block blockSoil = world.func_147439_a(x, y - 1, z);
        return PMPGenBase.isWaterPlantSoilBlock(blockSoil) && world.func_147439_a(x, y, z) == Blocks.field_150355_j;
    }

    public static boolean canReplaceBlockWithPlant(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == Blocks.field_150350_a || block == Blocks.field_150433_aE || block == Blocks.field_150329_H || block == Blocks.field_150395_bd || PMPGenBase.isLeafBlock(world, x, y, z);
    }

    public static boolean canReplaceBlockWithEpiphyte(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == Blocks.field_150350_a || block == Blocks.field_150395_bd || block == Blocks.field_150329_H || block == Blocks.field_150375_by;
    }

    public static boolean isSoilBlock(Block block) {
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150391_bh;
    }

    public static boolean isSoilBlock(World world, int x, int y, int z) {
        return PMPGenBase.isSoilBlock(world.func_147439_a(x, y, z));
    }

    public static boolean isSandBlock(Block block) {
        return block == Blocks.field_150354_m;
    }

    public static boolean isSandBlock(World world, int x, int y, int z) {
        return PMPGenBase.isSandBlock(world.func_147439_a(x, y, z));
    }

    public static boolean isLeafBlock(World world, int x, int y, int z) {
        ArrayList leafArray = OreDictionary.getOres((String)"treeLeaves");
        if (leafArray.isEmpty()) {
            return false;
        }
        ItemStack itemStack = new ItemStack(world.func_147439_a(x, y, z));
        for (int count = 0; count < leafArray.size(); ++count) {
            if (((ItemStack)leafArray.get(count)).func_77973_b() != itemStack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public static boolean isLogBlock(World world, int x, int y, int z) {
        ArrayList logArray = OreDictionary.getOres((String)"logWood");
        if (logArray.isEmpty()) {
            return false;
        }
        ItemStack itemStack = new ItemStack(world.func_147439_a(x, y, z));
        for (int count = 0; count < logArray.size(); ++count) {
            if (((ItemStack)logArray.get(count)).func_77973_b() != itemStack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public static boolean isWaterPlantSoilBlock(Block block) {
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150354_m || block == Blocks.field_150351_n;
    }

    public static int getClusterFrequency(Random random, int baseFreq) {
        return baseFreq + random.nextInt(baseFreq);
    }

    public static int getClusterSizeFromFreq(int frequency) {
        if (frequency < 3) {
            return 2;
        }
        if (frequency < 6) {
            return 3;
        }
        if (frequency < 9) {
            return 4;
        }
        return 5;
    }

    public static boolean canSpawnHangingPlantHere(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == Blocks.field_150350_a && (block = world.func_147439_a(x, y - 1, z)) == Blocks.field_150350_a && (block = world.func_147439_a(x, y - 2, z)) == Blocks.field_150350_a;
    }
}

