/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.feature;

import java.util.Random;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenGroundcover
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (locationData.biome.field_76791_y.matches("MushroomIsland") || locationData.biome.field_76791_y.matches("MushroomIslandShore")) {
            PMPGenGroundcover.generateMushroomIslandGroundcover(world, random, locationData);
        } else if (locationData.getBiomeTemperature() <= 0.5f) {
            PMPGenGroundcover.generateColdGroundcover(world, random, locationData);
        } else {
            PMPGenGroundcover.generateWarmGroundcover(world, random, locationData);
        }
        return true;
    }

    public static boolean generateMushroomIslandGroundcover(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 20) {
            if (PMPConfigPlants.groundcoverClover > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverClover, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverClover), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverClover));
            }
        } else if (PMPConfigPlants.groundcoverMoss > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverMoss, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverMoss), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverMoss));
        }
        return true;
    }

    public static boolean generateShadeGroundcover(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 80) {
            if (PMPConfigPlants.groundcoverLeavesGRN > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverLeavesGRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverLeavesGRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverLeavesGRN));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.groundcoverMoss > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverMoss, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverMoss), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverMoss));
            }
        } else if (PMPConfigPlants.groundcoverTwig > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverTwig, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverTwig), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverTwig));
        }
        return true;
    }

    public static boolean generateColdGroundcover(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 30) {
            if (PMPConfigPlants.groundcoverGrassGRNDK > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverGrassGRNDK, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverGrassGRNDK), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverGrassGRNDK));
            }
        } else if (distribution < 40) {
            if (PMPConfigPlants.groundcoverLeavesBRN > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverLeavesBRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverLeavesBRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverLeavesBRN));
            }
        } else if (distribution < 60) {
            if (PMPConfigPlants.groundcoverLeavesGRN > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverLeavesGRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverLeavesGRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverLeavesGRN));
            }
        } else if (distribution < 80) {
            if (PMPConfigPlants.groundcoverMoss > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverMoss, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverMoss), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverMoss));
            }
        } else if (PMPConfigPlants.groundcoverTwig > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverTwig, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverTwig), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverTwig));
        }
        return true;
    }

    public static boolean generateWarmGroundcover(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 10) {
            if (PMPConfigPlants.groundcoverClover > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverClover, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverClover), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverClover));
            }
        } else if (distribution < 20) {
            if (PMPConfigPlants.groundcoverFlowers > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverFlowers, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverFlowers), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverFlowers));
            }
        } else if (distribution < 30) {
            if (PMPConfigPlants.groundcoverGrassGRNDK > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverGrassGRNDK, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverGrassGRNDK), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverGrassGRNDK));
            }
        } else if (distribution < 40) {
            if (PMPConfigPlants.groundcoverGrassGRNLT > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverGrassGRNLT, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverGrassGRNLT), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverGrassGRNLT));
            }
        } else if (distribution < 50) {
            if (PMPConfigPlants.groundcoverIvy > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverIvy, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverIvy), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverIvy));
            }
        } else if (distribution < 70) {
            if (PMPConfigPlants.groundcoverLeavesBRN > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverLeavesBRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverLeavesBRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverLeavesBRN));
            }
        } else if (distribution < 80) {
            if (PMPConfigPlants.groundcoverLeavesGRN > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverLeavesGRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverLeavesGRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverLeavesGRN));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.groundcoverMoss > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverMoss, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverMoss), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverMoss));
            }
        } else if (PMPConfigPlants.groundcoverTwig > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.groundcoverTwig, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.groundcoverTwig), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.groundcoverTwig));
        }
        return true;
    }
}

