/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.vanilla.PMPGenMountain;

public abstract class PMPGenMountainEdge
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 3, 2);
            world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, Blocks.field_150325_L, 5, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genMountainEdge) {
            return false;
        }
        int distribution = random.nextInt(100);
        if (distribution < 50) {
            PMPGenMountain.generateMountainShrub(world, random, locationData);
        } else {
            PMPGenMountainEdge.generateMountainEdgePlant(world, random, locationData);
        }
        return true;
    }

    public static boolean generateMountainEdgePlant(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 50) {
            if (PMPConfigPlants.mountainNorhternWillowherb > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainNorthernWillowherb, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainNorhternWillowherb), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainNorhternWillowherb));
            }
        } else if (distribution < 70) {
            if (PMPConfigPlants.shrubAlpineCurrant > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubAlpineCurrant, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubAlpineCurrant), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubAlpineCurrant));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.flowerQuinoa > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerQuinoa, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerQuinoa), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerQuinoa));
            }
        } else if (PMPConfigPlants.berrybushBeauty > 0 && random.nextInt(10) < PMPConfigPlants.berrybushBeauty) {
            PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushBeauty, PMPBlocks.berrybushBeauty.getGrowthStages() - 1);
            PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
        }
        return true;
    }
}

