/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.vanilla.PMPGenOcean;

public abstract class PMPGenRiver
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 1, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genRiver) {
            return false;
        }
        int distribution = random.nextInt(100);
        boolean generated = false;
        if (locationData.getBiomeTemperature() >= 0.2f) {
            if (locationData.getBiomeTemperature() < 0.5f) {
                generated = true;
            } else if (locationData.getBiomeTemperature() < 0.6f) {
                if (distribution < 75) {
                    if (locationData.waterBlockDepth > 5) {
                        if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                            generated = PMPGenOcean.spawnKelp(world, random, locationData, PMPBlocks.waterKelpGiantGRN);
                        }
                    } else if (PMPConfigPlants.waterMondoGrass > 0) {
                        generated = PMPGenBase.placeWaterPlant(world, locationData, PMPBlocks.waterMondoGrass);
                    }
                } else if (locationData.waterBlockDepth > 5) {
                    if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                        generated = PMPGenOcean.spawnKelpCluster(world, random, locationData, PMPBlocks.waterKelpGiantGRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.waterKelpGiantGRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.waterKelpGiantGRN));
                    }
                } else if (PMPConfigPlants.waterMondoGrass > 0) {
                    generated = PMPGenBase.generateUnderwaterPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.waterMondoGrass, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.waterMondoGrass), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.waterMondoGrass));
                }
                generated = true;
            } else if (locationData.getBiomeTemperature() < 0.95f) {
                if (distribution < 75) {
                    if (locationData.waterBlockDepth > 5) {
                        if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                            generated = PMPGenOcean.spawnKelp(world, random, locationData, PMPBlocks.waterKelpGiantGRN);
                        }
                    } else if (PMPConfigPlants.waterDwarfHairGrass > 0) {
                        generated = PMPGenBase.placeWaterPlant(world, locationData, PMPBlocks.waterDwarfHairGrass);
                    }
                } else if (locationData.waterBlockDepth > 5) {
                    if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                        generated = PMPGenOcean.spawnKelpCluster(world, random, locationData, PMPBlocks.waterKelpGiantGRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.waterKelpGiantGRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.waterKelpGiantGRN));
                    }
                } else if (PMPConfigPlants.waterDwarfHairGrass > 0) {
                    generated = PMPGenBase.generateUnderwaterPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.waterDwarfHairGrass, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.waterDwarfHairGrass), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.waterDwarfHairGrass));
                }
                generated = true;
            } else if (locationData.getBiomeTemperature() < 1.0f) {
                if (distribution < 50) {
                    if (locationData.waterBlockDepth > 5) {
                        if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                            generated = PMPGenOcean.spawnKelp(world, random, locationData, PMPBlocks.waterKelpGiantGRN);
                        }
                    } else if (PMPConfigPlants.waterCryptWendtii > 0) {
                        generated = PMPGenBase.placeWaterPlant(world, locationData, PMPBlocks.waterCryptWendtii);
                    }
                } else if (locationData.waterBlockDepth > 5) {
                    if (PMPConfigPlants.waterKelpGiantGRN > 0) {
                        generated = PMPGenOcean.spawnKelpCluster(world, random, locationData, PMPBlocks.waterKelpGiantGRN, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.waterKelpGiantGRN), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.waterKelpGiantGRN));
                    }
                } else if (PMPConfigPlants.waterCryptWendtii > 0) {
                    generated = PMPGenBase.generateUnderwaterPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.waterCryptWendtii, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.waterCryptWendtii), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.waterCryptWendtii));
                }
            } else {
                generated = true;
            }
        }
        return generated;
    }
}

