/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenSwampEdge
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 12, 2);
            world.func_147465_d(locationData.x, locationData.y + 1, locationData.z, Blocks.field_150325_L, 5, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genSwampEdge) {
            return false;
        }
        return PMPGenSwampEdge.generateRandomSwampEdgePlant(world, random, locationData);
    }

    public static boolean generateRandomSwampEdgePlant(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 40) {
            if (PMPConfigPlants.grassCord > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.grassCord, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.grassCord), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.grassCord));
            }
        } else if (distribution < 50) {
            if (PMPConfigPlants.shrubCedarCylinder > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubCedarCylinder, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubCedarCylinder), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubCedarCylinder));
            }
        } else if (distribution < 60) {
            if (PMPConfigPlants.shrubCedarGlobe > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubCedarGlobe, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubCedarGlobe), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubCedarGlobe));
            }
        } else if (distribution < 70) {
            if (PMPConfigPlants.shrubCedarPyramid > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubCedarPyramid, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubCedarPyramid), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubCedarPyramid));
            }
        } else if (distribution < 80) {
            if (PMPConfigPlants.flowerTorchLily > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerTorchLily, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerTorchLily), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerTorchLily));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.flowerLily > 0) {
                PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerLily, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerLily), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerLily));
            }
        } else if (PMPConfigPlants.berrybushBlack > 0 && random.nextInt(10) < PMPConfigPlants.berrybushBlack) {
            PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushBlack, PMPBlocks.berrybushBlack.getGrowthStages() - 1);
            PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
        }
        return true;
    }
}

