/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.block;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import plantmegapack.api.PMPPlantCategory;
import plantmegapack.bin.PMPBlockPlant;
import plantmegapack.bin.PMPItems;
import plantmegapack.item.PMPItemCrop;

public class PMPBlockCrop
extends PMPBlockPlant {
    public PMPBlockCrop(String blockName, int growthStages, int invIconIndex, boolean tallPlant) {
        super(PMPPlantCategory.crop, blockName, growthStages, invIconIndex, tallPlant);
        GameRegistry.registerBlock((Block)this, PMPItemCrop.class, (String)blockName);
    }

    @Override
    public boolean func_149742_c(World world, int x, int y, int z) {
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        return (world.func_147439_a(x, y - 1, z) == Blocks.field_150458_ak || blockBelow.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this)) && world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metaData, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        String name = this.func_149739_a().substring(5);
        ItemStack itemStack = this.getSeedItemStack(name);
        if (itemStack != null) {
            ret.add(itemStack);
        }
        if (this.isFullyGrown(metaData) && (itemStack = this.getFoodItemStack(name)) != null) {
            ret.add(itemStack);
        }
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        String name = this.func_149739_a().substring(5);
        return this.getSeedItemStack(name);
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    @Override
    public boolean canPlantOnThisBlock(Block block) {
        return block == Blocks.field_150458_ak;
    }

    private ItemStack getFoodItemStack(String name) {
        if (name.matches("cropBeet")) {
            return new ItemStack((Item)PMPItems.foodBeet, 1, 0);
        }
        if (name.matches("cropBellPepperYellow")) {
            return new ItemStack((Item)PMPItems.foodBellPepperYellow, 1, 0);
        }
        if (name.matches("cropCelery")) {
            return new ItemStack((Item)PMPItems.foodCelery, 1, 0);
        }
        if (name.matches("cropCorn")) {
            return new ItemStack((Item)PMPItems.foodCorn, 1, 0);
        }
        if (name.matches("cropCucumber")) {
            return new ItemStack((Item)PMPItems.foodCucumber, 1, 0);
        }
        if (name.matches("cropLettuce")) {
            return new ItemStack((Item)PMPItems.foodLettuce, 1, 0);
        }
        if (name.matches("cropOnion")) {
            return new ItemStack((Item)PMPItems.foodOnion, 1, 0);
        }
        if (name.matches("cropSpinach")) {
            return new ItemStack((Item)PMPItems.foodSpinach, 1, 0);
        }
        if (name.matches("cropTomato")) {
            return new ItemStack((Item)PMPItems.foodTomato, 1, 0);
        }
        return null;
    }

    private ItemStack getSeedItemStack(String name) {
        if (name.matches("cropBeet")) {
            return new ItemStack((Item)PMPItems.seedBeet, 1, 0);
        }
        if (name.matches("cropBellPepperYellow")) {
            return new ItemStack((Item)PMPItems.seedBellPepperYellow, 1, 0);
        }
        if (name.matches("cropCelery")) {
            return new ItemStack((Item)PMPItems.seedCelery, 1, 0);
        }
        if (name.matches("cropCorn")) {
            return new ItemStack((Item)PMPItems.seedCorn, 1, 0);
        }
        if (name.matches("cropCucumber")) {
            return new ItemStack((Item)PMPItems.seedCucumber, 1, 0);
        }
        if (name.matches("cropLettuce")) {
            return new ItemStack((Item)PMPItems.seedLettuce, 1, 0);
        }
        if (name.matches("cropOnion")) {
            return new ItemStack((Item)PMPItems.seedOnion, 1, 0);
        }
        if (name.matches("cropSpinach")) {
            return new ItemStack((Item)PMPItems.seedSpinach, 1, 0);
        }
        if (name.matches("cropTomato")) {
            return new ItemStack((Item)PMPItems.seedTomato, 1, 0);
        }
        return null;
    }
}

