/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenBeachOcean
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 7, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genBeachOcean) {
            return false;
        }
        if (PMPGenBase.isSoilBlock(locationData.blockBelow)) {
            PMPGenBeachOcean.spawnGrassBeachPlant(world, random, locationData);
        } else if (PMPGenBase.isSandBlock(locationData.blockBelow)) {
            PMPGenBeachOcean.spawnRandomBeachPlantCluster(world, random, locationData);
        }
        return true;
    }

    public static boolean spawnGrassBeachPlant(World world, Random random, PMPSpawnLocation locationData) {
        BiomeGenBase biome = world.getBiomeGenForCoordsBody(locationData.x, locationData.z);
        int distribution = random.nextInt(100);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || (double)locationData.getBiomeTemperature() < 0.5) {
            if (distribution < 55) {
                if (PMPConfigPlants.grassFountain > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.grassFountain, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.grassFountain), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.grassFountain));
                }
            } else if (distribution < 85) {
                if (PMPConfigPlants.fernSword > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernSword, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernSword), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernSword));
                }
            } else if (locationData.y < 80) {
                if (PMPConfigPlants.flowerStreamsideBluebells > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerStreamsideBluebells, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerStreamsideBluebells), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerStreamsideBluebells));
                }
            } else if (PMPConfigPlants.flowerLupine > 0) {
                PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerLupine, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerLupine), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerLupine));
            }
        } else if (distribution < 15) {
            if (locationData.getBiomeTemperature() <= 0.6f) {
                if (PMPConfigPlants.shrubCypressGreen > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubCypressGreen, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubCypressGreen), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubCypressGreen));
                }
            } else if (PMPConfigPlants.shrubLindera > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubLindera, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubLindera), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubLindera));
            }
        } else if (distribution < 30) {
            if (PMPConfigPlants.flowerMediterraneanSeaHolly > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerMediterraneanSeaHolly, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerMediterraneanSeaHolly), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerMediterraneanSeaHolly));
            }
        } else if (distribution < 45) {
            if (PMPConfigPlants.flowerNemesia > 0) {
                PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerNemesia, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerNemesia), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerNemesia));
            }
        } else if (distribution < 60) {
            if (PMPConfigPlants.flowerBirdofParadise > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerBirdofParadise, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerBirdofParadise), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerBirdofParadise));
            }
        } else if (distribution < 75) {
            if (PMPConfigPlants.flowerBurningLove > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerBurningLove, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerBurningLove), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerBurningLove));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.leafyDustyMiller > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.leafyDustyMiller, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.leafyDustyMiller), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.leafyDustyMiller));
            }
        } else if (PMPConfigPlants.berrybushOrange > 0 && random.nextInt(10) < PMPConfigPlants.berrybushOrange) {
            PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushOrange, PMPBlocks.berrybushOrange.getGrowthStages() - 1);
            PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
        }
        return true;
    }

    public static boolean spawnRandomBeachPlantCluster(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 100 && PMPConfigPlants.grassSeaOats > 0) {
            PMPGenBase.generateRandomSandPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.grassSeaOats, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.grassSeaOats), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.grassSeaOats));
        }
        return true;
    }
}

