/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.bin;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import plantmegapack.worldgen.PMPGenBase;

public class PMPSpawnLocation {
    public boolean adjacentToBiomeEdge;
    public int adjacentToTree;
    public int adjacentToWater;
    public boolean canPlantCrop;
    public boolean canPlantEpiphyte;
    public int featureVillagePlant;
    public boolean isBeach;
    public boolean isInsideLeaf;
    public boolean isUnderTree;
    public int waterBlockDepth;
    public int waterType;
    public BiomeGenBase biome;
    public Block blockAbove;
    public Block blockBelow;
    public Block blockSpawn;
    public int x;
    public int y;
    public int z;

    public PMPSpawnLocation() {
        this.reset();
    }

    public void reset() {
        this.adjacentToBiomeEdge = false;
        this.adjacentToTree = 0;
        this.adjacentToWater = 0;
        this.canPlantCrop = false;
        this.canPlantEpiphyte = false;
        this.featureVillagePlant = 0;
        this.isBeach = false;
        this.isInsideLeaf = false;
        this.isUnderTree = false;
        this.biome = null;
        this.waterBlockDepth = 0;
        this.waterType = 0;
        this.blockAbove = null;
        this.blockBelow = null;
        this.blockSpawn = null;
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    private void getBlocks(World world, int ix, int iy, int iz) {
        this.biome = world.getBiomeGenForCoordsBody(this.x, this.z);
        this.blockAbove = world.func_147439_a(ix, iy + 1, iz);
        this.blockBelow = world.func_147439_a(ix, iy - 1, iz);
        this.blockSpawn = world.func_147439_a(ix, iy, iz);
    }

    public float getBiomeTemperature() {
        return this.biome.func_150564_a(this.x, this.y, this.z);
    }

    public boolean getSpawnLocationData(World world, Random random) {
        this.getBlocks(world, this.x, this.y, this.z);
        this.adjacentToBiomeEdge = PMPGenBase.isAdjacentToDifferentBiome(this.biome, world, this.x, this.y, this.z);
        if (PMPGenBase.isLeafBlock(world, this.x, this.y - 1, this.z) && this.adjustLocationForLeaf(world, random)) {
            return true;
        }
        if (this.checkForVillageRoof(world)) {
            return true;
        }
        if (this.checkForWaterType(world)) {
            return true;
        }
        if (this.checkForAdjacentWater(world)) {
            return true;
        }
        if (this.biome.field_76791_y.contains("beach") || this.biome.field_76791_y.contains("Beach")) {
            this.isBeach = true;
            return true;
        }
        if (this.blockSpawn == Blocks.field_150464_aj) {
            this.canPlantCrop = true;
            return true;
        }
        return !PMPGenBase.isLogBlock(world, this.x, this.y - 1, this.z);
    }

    private boolean checkForVillageRoof(World world) {
        Block block = world.func_147439_a(this.x, this.y - 1, this.z);
        Block blockBelow = world.func_147439_a(this.x, this.y - 2, this.z);
        Block blockBelow2 = world.func_147439_a(this.x, this.y - 3, this.z);
        if (!(block != Blocks.field_150400_ck && block != Blocks.field_150487_bG && block != Blocks.field_150401_cl && block != Blocks.field_150476_ad && block != Blocks.field_150485_bF && block != Blocks.field_150333_U && !PMPGenBase.isLogBlock(world, this.x, this.y - 1, this.z) || blockBelow != Blocks.field_150347_e && blockBelow != Blocks.field_150344_f || blockBelow2 != Blocks.field_150347_e && blockBelow2 != Blocks.field_150344_f)) {
            if (PMPGenBase.canSpawnHangingPlantHere(world, this.x, this.y - 2, this.z - 1)) {
                this.y -= 2;
                --this.z;
                this.featureVillagePlant = 3;
                return true;
            }
            if (PMPGenBase.canSpawnHangingPlantHere(world, this.x - 1, this.y - 2, this.z)) {
                --this.x;
                this.y -= 2;
                this.featureVillagePlant = 5;
                return true;
            }
            if (PMPGenBase.canSpawnHangingPlantHere(world, this.x + 1, this.y - 2, this.z)) {
                ++this.x;
                this.y -= 2;
                this.featureVillagePlant = 4;
                return true;
            }
            if (PMPGenBase.canSpawnHangingPlantHere(world, this.x, this.y - 2, this.z + 1)) {
                this.y -= 2;
                ++this.z;
                this.featureVillagePlant = 2;
                return true;
            }
        }
        return false;
    }

    private boolean checkForWaterType(World world) {
        if (this.blockBelow == Blocks.field_150355_j) {
            if (this.blockSpawn != Blocks.field_150350_a) {
                return false;
            }
            Block blockTemp = world.func_147439_a(this.x, this.y - 2, this.z);
            if (blockTemp != Blocks.field_150355_j && blockTemp.func_149688_o() != Material.field_151586_h) {
                this.waterType = this.biome.field_76791_y.contains("beach") || this.biome.field_76791_y.contains("Beach") || this.biome.field_76791_y.contains("ocean") || this.biome.field_76791_y.contains("Ocean") ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 3 : 2) : (this.biome.field_76791_y.contains("river") || this.biome.field_76791_y.contains("River") ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 6 : 5) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 6 : 8) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 6 : 13) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 6 : 11) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 14 : 15) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 6 : 12) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT) ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 6 : 9) : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) ? (PMPGenBase.isSurroundedByBlock(world, this.x, this.y - 1, this.z, Blocks.field_150355_j) ? 6 : 10) : 4))))))));
                return true;
            }
            this.adjustLocationForWaterBlock(world);
            this.waterType = this.biome.field_76791_y.contains("beach") || this.biome.field_76791_y.contains("Beach") || this.biome.field_76791_y.contains("ocean") || this.biome.field_76791_y.contains("Ocean") ? 1 : (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) ? 16 : 4);
            return true;
        }
        return false;
    }

    private void adjustLocationForWaterBlock(World world) {
        int startHeight = this.y;
        while (this.blockBelow == Blocks.field_150355_j || this.blockBelow.func_149688_o() == Material.field_151586_h) {
            --this.y;
            this.blockBelow = world.func_147439_a(this.x, this.y - 1, this.z);
        }
        this.getBlocks(world, this.x, this.y, this.z);
        this.waterBlockDepth = startHeight - this.y;
    }

    private boolean adjustLocationForLeaf(World world, Random random) {
        int maxHeight = -1;
        boolean canContinueDown = true;
        do {
            --this.y;
            boolean leafBlock = PMPGenBase.isLeafBlock(world, this.x, this.y, this.z);
            if (PMPGenBase.canReplaceBlockWithEpiphyte(world, this.x, this.y, this.z) || leafBlock) {
                if (this.adjacentToTree == 0 && !leafBlock) {
                    this.checkForAdjacentTrees(world, random);
                    if (this.adjacentToTree > 0) {
                        if (maxHeight < 0) {
                            maxHeight = this.y;
                        }
                        this.canPlantEpiphyte = true;
                    }
                }
                leafBlock = PMPGenBase.isLeafBlock(world, this.x, this.y - 1, this.z);
                if (PMPGenBase.canReplaceBlockWithEpiphyte(world, this.x, this.y - 1, this.z) || leafBlock) {
                    switch (this.adjacentToTree) {
                        case 2: {
                            canContinueDown = PMPGenBase.isLogBlock(world, this.x, this.y - 1, this.z + 1);
                            break;
                        }
                        case 3: {
                            canContinueDown = PMPGenBase.isLogBlock(world, this.x, this.y - 1, this.z - 1);
                            break;
                        }
                        case 4: {
                            canContinueDown = PMPGenBase.isLogBlock(world, this.x + 1, this.y - 1, this.z);
                            break;
                        }
                        case 5: {
                            canContinueDown = PMPGenBase.isLogBlock(world, this.x - 1, this.y - 1, this.z);
                            break;
                        }
                    }
                    continue;
                }
                canContinueDown = false;
                continue;
            }
            canContinueDown = false;
        } while (canContinueDown && this.blockBelow.func_149712_f(world, this.x, this.y - 1, this.z) <= 0.2f);
        this.getBlocks(world, this.x, this.y, this.z);
        if (this.canPlantEpiphyte) {
            if (maxHeight > this.y) {
                this.y += random.nextInt(1 + (maxHeight - this.y));
            }
            return true;
        }
        this.isUnderTree = true;
        if (PMPGenBase.isSoilBlock(this.blockBelow) || PMPGenBase.isSandBlock(this.blockBelow)) {
            if (PMPGenBase.isLeafBlock(world, this.x, this.y, this.z)) {
                this.isInsideLeaf = true;
                return true;
            }
            return world.func_147437_c(this.x, this.y, this.z);
        }
        return false;
    }

    private void checkForAdjacentTrees(World world, Random random) {
        if (PMPGenBase.isLogBlock(world, this.x, this.y, this.z - 1)) {
            this.adjacentToTree = 3;
        }
        if (PMPGenBase.isLogBlock(world, this.x - 1, this.y, this.z)) {
            this.adjacentToTree = 5;
        }
        if (PMPGenBase.isLogBlock(world, this.x + 1, this.y, this.z)) {
            this.adjacentToTree = 4;
        }
        if (PMPGenBase.isLogBlock(world, this.x, this.y, this.z + 1)) {
            this.adjacentToTree = 2;
        }
        if (this.adjacentToTree == 0) {
            if (PMPGenBase.isLogBlock(world, this.x - 1, this.y, this.z - 1)) {
                this.adjacentToTree = 6;
            } else if (PMPGenBase.isLogBlock(world, this.x + 1, this.y, this.z - 1)) {
                this.adjacentToTree = 7;
            } else if (PMPGenBase.isLogBlock(world, this.x - 1, this.y, this.z + 1)) {
                this.adjacentToTree = 8;
            } else if (PMPGenBase.isLogBlock(world, this.x + 1, this.y, this.z + 1)) {
                this.adjacentToTree = 9;
            }
            if (this.adjacentToTree > 5) {
                this.adjustLocationForDiagonalHostTree(random);
                this.getBlocks(world, this.x, this.y, this.z);
                this.canPlantEpiphyte = true;
            }
        }
    }

    private boolean checkForAdjacentWater(World world) {
        Block blockTemp = world.func_147439_a(this.x, this.y - 1, this.z - 1);
        if (blockTemp == Blocks.field_150355_j) {
            this.adjacentToWater = 3;
        }
        if ((blockTemp = world.func_147439_a(this.x + 1, this.y - 1, this.z)) == Blocks.field_150355_j) {
            this.adjacentToWater = 4;
        }
        if ((blockTemp = world.func_147439_a(this.x, this.y - 1, this.z + 1)) == Blocks.field_150355_j) {
            this.adjacentToWater = 2;
        }
        if ((blockTemp = world.func_147439_a(this.x - 1, this.y - 1, this.z)) == Blocks.field_150355_j) {
            this.adjacentToWater = 5;
        }
        return this.adjacentToWater > 0;
    }

    private void adjustLocationForDiagonalHostTree(Random random) {
        int distribution = random.nextInt(100);
        switch (this.adjacentToTree) {
            case 6: {
                if (distribution < 50) {
                    --this.x;
                    this.adjacentToTree = 3;
                    break;
                }
                --this.z;
                this.adjacentToTree = 5;
                break;
            }
            case 7: {
                if (distribution < 50) {
                    ++this.x;
                    this.adjacentToTree = 3;
                    break;
                }
                --this.z;
                this.adjacentToTree = 4;
                break;
            }
            case 8: {
                if (distribution < 50) {
                    ++this.z;
                    this.adjacentToTree = 5;
                    break;
                }
                --this.x;
                this.adjacentToTree = 2;
                break;
            }
            case 9: {
                if (distribution < 50) {
                    ++this.z;
                    this.adjacentToTree = 4;
                    break;
                }
                ++this.x;
                this.adjacentToTree = 2;
                break;
            }
        }
    }
}

