/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import plantmegapack.api.PMPPlantCategory;
import plantmegapack.bin.PMPBlockPlant;
import plantmegapack.bin.PMPItems;
import plantmegapack.item.PMPItemBerrybush;

public class PMPBlockBerrybush
extends PMPBlockPlant {
    public PMPBlockBerrybush(String blockName, int growthStages, int invIconIndex, boolean tallPlant) {
        super(PMPPlantCategory.berrybush, blockName, growthStages, invIconIndex, tallPlant);
        GameRegistry.registerBlock((Block)this, PMPItemBerrybush.class, (String)blockName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        int growthStages;
        String iconName = this.func_149739_a().substring(5);
        int iconsToLoad = growthStages = this.getGrowthStages();
        this.textures = new IIcon[growthStages];
        this.textures[0] = ir.func_94245_a("plantmegapack:berrybushBare");
        for (int count = 1; count < growthStages; ++count) {
            this.textures[count] = ir.func_94245_a("plantmegapack:" + iconName + String.valueOf(count));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metaData, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack berryBush = new ItemStack((Block)this, 1);
        ret.add(berryBush);
        if (this.isFullyGrown(metaData)) {
            ret.add(this.getBerryItemStack(metaData));
        }
        return ret;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int metaData = world.func_72805_g(x, y, z);
        if (this.isFullyGrown(metaData)) {
            this.func_149642_a(world, x, y, z, this.getBerryItemStack(metaData));
            world.func_72921_c(x, y, z, 0, 2);
            return true;
        }
        return false;
    }

    private ItemStack getBerryItemStack(int metaData) {
        String blockName = this.func_149739_a().substring(5);
        ItemStack berries = null;
        if (this.isFullyGrown(metaData)) {
            if (blockName.matches("berrybushBeauty")) {
                berries = new ItemStack((Item)PMPItems.berriesBeauty, 1);
            } else if (blockName.matches("berrybushBlack")) {
                berries = new ItemStack((Item)PMPItems.berriesBlack, 1);
            } else if (blockName.matches("berrybushBlue")) {
                berries = new ItemStack((Item)PMPItems.berriesBlue, 1);
            } else if (blockName.matches("berrybushElder")) {
                berries = new ItemStack((Item)PMPItems.berriesElder, 1);
            } else if (blockName.matches("berrybushGoose")) {
                berries = new ItemStack((Item)PMPItems.berriesGoose, 1);
            } else if (blockName.matches("berrybushHuckle")) {
                berries = new ItemStack((Item)PMPItems.berriesHuckle, 1);
            } else if (blockName.matches("berrybushOrange")) {
                berries = new ItemStack((Item)PMPItems.berriesOrange, 1);
            } else if (blockName.matches("berrybushSnow")) {
                berries = new ItemStack((Item)PMPItems.berriesSnow, 1);
            } else if (blockName.matches("berrybushStraw")) {
                berries = new ItemStack((Item)PMPItems.berriesStraw, 1);
            }
        }
        return berries;
    }
}

