/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import plantmegapack.PlantMegaPack;
import plantmegapack.bin.PMPRenderers;
import plantmegapack.item.PMPItemEpiphyte;
import plantmegapack.worldgen.PMPGenBase;

public class PMPBlockEpiphyte
extends Block {
    public String scientificName = "";
    private int renderType;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] textures;

    public PMPBlockEpiphyte(String blockName, int renderTypeID) {
        super(Material.field_151585_k);
        this.func_149663_c(blockName);
        this.func_149647_a(PlantMegaPack.modCreativeTabPlants);
        if (blockName.matches("epiphyteArtistsConk") || blockName.matches("epiphyteSulphurShelf") || blockName.matches("epiphyteTurkeyTail") || blockName.matches("epiphyteApacheDwarf")) {
            this.func_149672_a(Block.field_149766_f);
        } else {
            this.func_149672_a(Block.field_149779_h);
        }
        this.renderType = renderTypeID;
        this.scientificName = LanguageRegistry.instance().getStringLocalization("tile." + blockName + ".snam");
        GameRegistry.registerBlock((Block)this, PMPItemEpiphyte.class, (String)blockName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        String iconName = this.func_149739_a().substring(5);
        if (this.renderType == 2) {
            this.textures = new IIcon[3];
            for (int count = 0; count < 3; ++count) {
                this.textures[count] = icon.func_94245_a("plantmegapack:" + iconName + String.valueOf(count));
            }
        } else {
            this.textures = new IIcon[1];
            this.textures[0] = icon.func_94245_a("plantmegapack:" + iconName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        if (this.renderType == 2 && metaData < this.textures.length) {
            return this.textures[metaData];
        }
        return this.textures[0];
    }

    public int func_149645_b() {
        switch (this.renderType) {
            case 1: {
                return 1;
            }
            case 2: {
                return PMPRenderers.renderEpiphyteHorizontalID;
            }
            case 3: {
                return PMPRenderers.renderEpiphyteVerticalID;
            }
        }
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metaData) {
        int j1 = metaData;
        if ((j1 == 0 || side == 2) && this.canAttachToBlock(world, x, y, z + 1)) {
            j1 = 2;
        }
        if ((j1 == 0 || side == 3) && this.canAttachToBlock(world, x, y, z - 1)) {
            j1 = 3;
        }
        if ((j1 == 0 || side == 4) && this.canAttachToBlock(world, x + 1, y, z)) {
            j1 = 4;
        }
        if ((j1 == 0 || side == 5) && this.canAttachToBlock(world, x - 1, y, z)) {
            j1 = 5;
        }
        return j1;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        boolean result = true;
        int metaData = world.func_72805_g(x, y, z);
        switch (metaData) {
            case 2: {
                result = this.canAttachToBlock(world, x, y, z + 1);
                break;
            }
            case 3: {
                result = this.canAttachToBlock(world, x, y, z - 1);
                break;
            }
            case 4: {
                result = this.canAttachToBlock(world, x + 1, y, z);
                break;
            }
            case 5: {
                result = this.canAttachToBlock(world, x - 1, y, z);
                break;
            }
        }
        return result;
    }

    private boolean canAttachToBlock(World world, int x, int y, int z) {
        return PMPGenBase.isLogBlock(world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.canAttachToBlock(world, x - 1, y, z) || this.canAttachToBlock(world, x + 1, y, z) || this.canAttachToBlock(world, x, y, z - 1) || this.canAttachToBlock(world, x, y, z + 1);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.05f, 0.05f, 0.05f, 0.95f, 0.95f, 0.95f);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return 0;
    }
}

