/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import plantmegapack.PlantMegaPack;
import plantmegapack.item.PMPItemFlowerMulti;

public class PMPBlockFlowerMulti
extends Block
implements IPlantable {
    public static final int maxFlowerColors = 13;
    public static final String[] colorNames = new String[]{"Burgundy", "Red", "Coral", "Orange", "Yellow", "Green", "Cyan", "Blue", "Royal", "Purple", "Magenta", "Pink", "White"};
    public String scientificName = "";
    HashMap<Integer, Integer> colorMap = new HashMap();
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] textures;

    public PMPBlockFlowerMulti(String blockName, String colorBitField) {
        super(Material.field_151585_k);
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.9f, 0.9f);
        this.func_149647_a(PlantMegaPack.modCreativeTabPlants);
        this.func_149663_c(blockName);
        this.func_149672_a(Block.field_149779_h);
        GameRegistry.registerBlock((Block)this, PMPItemFlowerMulti.class, (String)blockName);
        this.scientificName = LanguageRegistry.instance().getStringLocalization("tile." + blockName + ".snam");
        int colorIndex = 0;
        for (int count = 0; count < 13; ++count) {
            if (colorBitField.charAt(count) != '1') continue;
            this.colorMap.put(colorIndex++, count);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        String iconName = this.func_149739_a().substring(5);
        this.textures = new IIcon[this.colorMap.size()];
        for (int count = 0; count < this.colorMap.size(); ++count) {
            this.textures[count] = ir.func_94245_a("plantmegapack:" + iconName + colorNames[this.colorMap.get(count)]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        if (metaData < 0 || metaData > this.textures.length - 1) {
            return this.textures[0];
        }
        return this.textures[metaData];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int count = 0; count < this.colorMap.size(); ++count) {
            subItems.add(new ItemStack((Block)this, 1, count));
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public int func_149645_b() {
        return 1;
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        return this.canReplaceBlock(block) && this.canPlantOnThisBlock(blockBelow);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        return this.canPlantOnThisBlock(blockBelow);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            int metaData = world.func_72805_g(x, y, z);
            this.func_149697_b(world, x, y, z, metaData, 0);
            world.func_147468_f(x, y, z);
        }
    }

    protected boolean canReplaceBlock(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150329_H || block == Blocks.field_150395_bd;
    }

    public boolean canPlantOnThisBlock(Block block) {
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak;
    }

    public int getFlowerColorCount() {
        return colorNames.length;
    }
}

