/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;
import plantmegapack.worldgen.feature.PMPGenEpiphyte;
import plantmegapack.worldgen.feature.PMPGenFungus;
import plantmegapack.worldgen.feature.PMPGenGroundcover;
import plantmegapack.worldgen.feature.PMPGenVillageCrop;
import plantmegapack.worldgen.feature.PMPGenVillageHangingPlant;
import plantmegapack.worldgen.vanilla.PMPGenBeachCold;
import plantmegapack.worldgen.vanilla.PMPGenBeachOcean;
import plantmegapack.worldgen.vanilla.PMPGenBeachStone;
import plantmegapack.worldgen.vanilla.PMPGenColdForest;
import plantmegapack.worldgen.vanilla.PMPGenColdForestEdge;
import plantmegapack.worldgen.vanilla.PMPGenColdForestShade;
import plantmegapack.worldgen.vanilla.PMPGenColdForestWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenDesert;
import plantmegapack.worldgen.vanilla.PMPGenDesertEdge;
import plantmegapack.worldgen.vanilla.PMPGenDesertHill;
import plantmegapack.worldgen.vanilla.PMPGenDesertSlope;
import plantmegapack.worldgen.vanilla.PMPGenDesertWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenForest;
import plantmegapack.worldgen.vanilla.PMPGenForestEdge;
import plantmegapack.worldgen.vanilla.PMPGenForestShade;
import plantmegapack.worldgen.vanilla.PMPGenForestWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenFrozen;
import plantmegapack.worldgen.vanilla.PMPGenFrozenEdge;
import plantmegapack.worldgen.vanilla.PMPGenFrozenWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenJungle;
import plantmegapack.worldgen.vanilla.PMPGenJungleEdge;
import plantmegapack.worldgen.vanilla.PMPGenJungleShade;
import plantmegapack.worldgen.vanilla.PMPGenJungleWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenMesa;
import plantmegapack.worldgen.vanilla.PMPGenMesaEdge;
import plantmegapack.worldgen.vanilla.PMPGenMountain;
import plantmegapack.worldgen.vanilla.PMPGenMountainEdge;
import plantmegapack.worldgen.vanilla.PMPGenMountainSlope;
import plantmegapack.worldgen.vanilla.PMPGenMountainStone;
import plantmegapack.worldgen.vanilla.PMPGenMountainWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenMushroomIsland;
import plantmegapack.worldgen.vanilla.PMPGenMushroomIslandEdge;
import plantmegapack.worldgen.vanilla.PMPGenMushroomIslandWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenOcean;
import plantmegapack.worldgen.vanilla.PMPGenOceanEdge;
import plantmegapack.worldgen.vanilla.PMPGenOceanSurface;
import plantmegapack.worldgen.vanilla.PMPGenPlains;
import plantmegapack.worldgen.vanilla.PMPGenPlainsEdge;
import plantmegapack.worldgen.vanilla.PMPGenPlainsWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenRiver;
import plantmegapack.worldgen.vanilla.PMPGenRiverEdge;
import plantmegapack.worldgen.vanilla.PMPGenRiverSurface;
import plantmegapack.worldgen.vanilla.PMPGenRiverValley;
import plantmegapack.worldgen.vanilla.PMPGenSavanna;
import plantmegapack.worldgen.vanilla.PMPGenSavannaEdge;
import plantmegapack.worldgen.vanilla.PMPGenSavannaShade;
import plantmegapack.worldgen.vanilla.PMPGenSwamp;
import plantmegapack.worldgen.vanilla.PMPGenSwampEdge;
import plantmegapack.worldgen.vanilla.PMPGenSwampShade;
import plantmegapack.worldgen.vanilla.PMPGenSwampWater;
import plantmegapack.worldgen.vanilla.PMPGenSwampWaterEdge;
import plantmegapack.worldgen.vanilla.PMPGenSwampWaterSurface;
import plantmegapack.worldgen.vanilla.PMPGenWasteland;
import plantmegapack.worldgen.vanilla.PMPGenWastelandEdge;

public class PMPWorldGenerator
implements IWorldGenerator {
    private PMPSpawnLocation locationData = new PMPSpawnLocation();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                if (!PMPConfigWorldgen.controlNether) break;
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                if (!PMPConfigWorldgen.controlOverworld) break;
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
        }
    }

    private void generateNether(World world, Random random, int chunkX, int chunkZ) {
    }

    private void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        boolean generated = false;
        for (int count = 0; count < PMPConfigWorldgen.controlPassesPerChuck; ++count) {
            generated = false;
            this.locationData.reset();
            this.locationData.x = chunkX + random.nextInt(16);
            this.locationData.z = chunkZ + random.nextInt(16);
            this.locationData.y = world.func_72976_f(this.locationData.x, this.locationData.z);
            if (!this.locationData.getSpawnLocationData(world, random)) continue;
            if (this.locationData.waterType > 0) {
                generated = this.generateSurfaceWater(world, random);
            }
            if (!generated && this.locationData.adjacentToWater > 0) {
                generated = this.generateSurfaceWaterEdge(world, random);
            }
            if (!generated && this.locationData.canPlantCrop) {
                generated = PMPGenVillageCrop.generate(world, random, this.locationData);
            }
            if (!generated && this.locationData.canPlantEpiphyte) {
                generated = PMPGenEpiphyte.generate(world, random, this.locationData);
            }
            if (!generated && this.locationData.isUnderTree) {
                generated = this.generateSurfaceUnderTree(world, random);
            }
            if (!generated && this.locationData.isBeach) {
                generated = this.generateSurfaceBeach(world, random);
            }
            if (!generated && this.locationData.adjacentToBiomeEdge) {
                generated = this.generateSurfaceBiomeEdges(world, random);
            }
            if (!generated) {
                generated = this.generateSurfaceBiomes(world, random);
            }
            if (!generated && this.locationData.biome.field_76791_y.contains("river") || this.locationData.biome.field_76791_y.contains("River")) {
                generated = PMPGenRiverValley.generate(world, random, this.locationData);
            }
            if (generated || this.locationData.featureVillagePlant <= 0) continue;
            generated = PMPGenVillageHangingPlant.spawnRandomHangingPlant(world, random, this.locationData);
        }
    }

    private boolean generateSurfaceBeach(World world, Random random) {
        boolean generated = false;
        generated = this.locationData.biome.field_76791_y.matches("Cold Beach") ? PMPGenBeachCold.generate(world, random, this.locationData) : (this.locationData.biome.field_76791_y.matches("Stone Beach") ? PMPGenBeachStone.generate(world, random, this.locationData) : PMPGenBeachOcean.generate(world, random, this.locationData));
        return generated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean generateSurfaceBiomeEdges(World world, Random random) {
        boolean generated = false;
        if (this.locationData.biome.field_76791_y.matches("MushroomIsland")) {
            generated = PMPGenMushroomIslandEdge.generate(world, random, this.locationData);
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            if (this.locationData.getBiomeTemperature() < 0.6f) {
                generated = PMPGenColdForestEdge.generate(world, random, this.locationData);
                return true;
            } else {
                if (!(this.locationData.getBiomeTemperature() < 1.0f)) return false;
                generated = PMPGenForestEdge.generate(world, random, this.locationData);
            }
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            generated = PMPGenSwampEdge.generate(world, random, this.locationData);
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            generated = PMPGenJungleEdge.generate(world, random, this.locationData);
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            generated = PMPGenBase.isSandBlock(this.locationData.blockBelow) ? PMPGenDesertEdge.generate(world, random, this.locationData) : (PMPGenBase.isSoilBlock(this.locationData.blockBelow) ? PMPGenSavannaEdge.generate(world, random, this.locationData) : PMPGenMesaEdge.generate(world, random, this.locationData));
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            generated = this.locationData.biome.field_76791_y.matches("Roofed Forest") ? PMPGenForestEdge.generate(world, random, this.locationData) : PMPGenPlainsEdge.generate(world, random, this.locationData);
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            generated = PMPGenMountainEdge.generate(world, random, this.locationData);
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
            generated = PMPGenFrozenEdge.generate(world, random, this.locationData);
            return true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            generated = PMPGenOceanEdge.generate(world, random, this.locationData);
            return true;
        } else {
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) return true;
            generated = PMPGenWastelandEdge.generate(world, random, this.locationData);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean generateSurfaceBiomes(World world, Random random) {
        boolean generated = false;
        if (this.locationData.biome.field_76791_y.matches("Roofed Forest")) {
            generated = PMPGenGroundcover.generate(world, random, this.locationData);
            return PMPGenForest.generate(world, random, this.locationData);
        }
        if (this.locationData.biome.field_76791_y.matches("MushroomIsland")) return PMPGenMushroomIsland.generate(world, random, this.locationData);
        if (this.locationData.biome.field_76791_y.matches("MushroomIslandShore")) {
            return PMPGenMushroomIsland.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            if (this.locationData.getBiomeTemperature() < 0.6f) return PMPGenColdForest.generate(world, random, this.locationData);
            if (this.locationData.biome.field_76791_y.contains("taiga")) return PMPGenColdForest.generate(world, random, this.locationData);
            if (this.locationData.biome.field_76791_y.contains("Taiga")) {
                return PMPGenColdForest.generate(world, random, this.locationData);
            }
            if (!(this.locationData.getBiomeTemperature() < 1.0f)) return false;
            return PMPGenForest.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            if (!this.locationData.adjacentToBiomeEdge) return PMPGenSwamp.generate(world, random, this.locationData);
            return PMPGenSwampEdge.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return PMPGenJungle.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            if (this.locationData.blockSpawn != Blocks.field_150350_a) return generated;
            if (PMPGenBase.isSandBlock(this.locationData.blockBelow)) {
                if (PMPGenBase.isAdjacentToBlock2(world, this.locationData.x, this.locationData.y - 2, this.locationData.z, Blocks.field_150350_a)) {
                    return PMPGenDesertSlope.generate(world, random, this.locationData);
                }
                if (this.locationData.y > 75) return PMPGenDesertHill.generate(world, random, this.locationData);
                return PMPGenDesert.generate(world, random, this.locationData);
            }
            if (!PMPGenBase.isSoilBlock(this.locationData.blockBelow)) return PMPGenMesa.generate(world, random, this.locationData);
            return PMPGenSavanna.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            if (!this.locationData.biome.field_76791_y.matches("Roofed Forest")) return PMPGenPlains.generate(world, random, this.locationData);
            return PMPGenForest.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            if (this.locationData.blockBelow == Blocks.field_150348_b) {
                return PMPGenMountainStone.generate(world, random, this.locationData);
            }
            if (!PMPGenBase.isAdjacentToBlock(world, this.locationData.x, this.locationData.y - 1, this.locationData.z, Blocks.field_150350_a)) return PMPGenMountain.generate(world, random, this.locationData);
            if (!PMPGenBase.isAdjacentToBlock2(world, this.locationData.x, this.locationData.y - 2, this.locationData.z, Blocks.field_150350_a)) return PMPGenMountain.generate(world, random, this.locationData);
            return PMPGenMountainSlope.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
            return PMPGenFrozen.generate(world, random, this.locationData);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            return PMPGenBeachOcean.generate(world, random, this.locationData);
        }
        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) return generated;
        return PMPGenWasteland.generate(world, random, this.locationData);
    }

    private boolean generateSurfaceUnderTree(World world, Random random) {
        boolean generated = false;
        if (world.func_72883_k(this.locationData.x, this.locationData.y, this.locationData.z) < 13) {
            generated = PMPGenFungus.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            generated = this.locationData.getBiomeTemperature() < 0.5f ? PMPGenColdForestShade.generate(world, random, this.locationData) : PMPGenForestShade.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            generated = PMPGenSwampShade.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            generated = PMPGenJungleShade.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            generated = PMPGenSavannaShade.generate(world, random, this.locationData);
        }
        return generated;
    }

    private boolean generateSurfaceWater(World world, Random random) {
        boolean generated = false;
        switch (this.locationData.waterType) {
            case 1: {
                generated = PMPGenOcean.generate(world, random, this.locationData);
                break;
            }
            case 2: {
                generated = PMPGenOceanEdge.generate(world, random, this.locationData);
                break;
            }
            case 3: {
                generated = PMPGenOceanSurface.generate(world, random, this.locationData);
                break;
            }
            case 4: {
                generated = PMPGenRiver.generate(world, random, this.locationData);
                break;
            }
            case 5: {
                generated = PMPGenRiverEdge.generate(world, random, this.locationData);
                break;
            }
            case 6: {
                generated = PMPGenRiverSurface.generate(world, random, this.locationData);
                break;
            }
            case 7: {
                generated = PMPGenColdForestWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 8: {
                generated = PMPGenForestWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 9: {
                generated = PMPGenDesertWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 10: {
                generated = PMPGenFrozenWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 11: {
                generated = PMPGenJungleWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 12: {
                generated = PMPGenMountainWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 13: {
                generated = PMPGenPlainsWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 14: {
                generated = PMPGenSwampWaterSurface.generate(world, random, this.locationData);
                break;
            }
            case 15: {
                generated = PMPGenSwampWaterEdge.generate(world, random, this.locationData);
                break;
            }
            case 16: {
                generated = PMPGenSwampWater.generate(world, random, this.locationData);
            }
        }
        return generated;
    }

    private boolean generateSurfaceWaterEdge(World world, Random random) {
        boolean generated = false;
        if (this.locationData.biome.field_76791_y.matches("MushroomIsland") || this.locationData.biome.field_76791_y.matches("MushroomIslandShore")) {
            generated = PMPGenMushroomIslandWaterEdge.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            generated = PMPGenJungleWaterEdge.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            if (this.locationData.getBiomeTemperature() <= 0.4f) {
                generated = PMPGenColdForestWaterEdge.generate(world, random, this.locationData);
            } else if (this.locationData.getBiomeTemperature() <= 1.0f) {
                generated = PMPGenForestWaterEdge.generate(world, random, this.locationData);
            }
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            generated = PMPGenSwampWaterEdge.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            generated = PMPGenMountainWaterEdge.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            generated = PMPGenPlainsWaterEdge.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            generated = PMPGenDesertWaterEdge.generate(world, random, this.locationData);
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)this.locationData.biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
            generated = PMPGenFrozenWaterEdge.generate(world, random, this.locationData);
        }
        return generated;
    }
}

