/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenFungus
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        boolean generated = false;
        if (locationData.getBiomeTemperature() <= 0.5f) {
            if (distribution < 40) {
                if (PMPConfigPlants.fungusDeathCap > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusDeathCap, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusDeathCap), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusDeathCap));
                }
            } else if (distribution < 80) {
                if (PMPConfigPlants.fungusGiantClub > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusGiantClub, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusGiantClub), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusGiantClub));
                }
            } else if (PMPConfigPlants.fungusParasol > 0) {
                generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusParasol, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusParasol), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusParasol));
            }
        } else if (locationData.getBiomeTemperature() < 0.95f) {
            if (distribution < 16) {
                if (PMPConfigPlants.fungusChanterelle > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusChanterelle, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusChanterelle), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusChanterelle));
                }
            } else if (distribution < 32) {
                if (PMPConfigPlants.fungusParasol > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusParasol, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusParasol), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusParasol));
                }
            } else if (distribution < 48) {
                if (PMPConfigPlants.fungusStinkhorn > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusStinkhorn, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusStinkhorn), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusStinkhorn));
                }
            } else if (distribution < 64) {
                if (PMPConfigPlants.fungusWeepingMilkCap > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusWeepingMilkCap, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusWeepingMilkCap), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusWeepingMilkCap));
                }
            } else if (distribution < 80) {
                if (PMPConfigPlants.fungusWoodBlewit > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusWoodBlewit, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusWoodBlewit), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusWoodBlewit));
                }
            } else if (distribution < 96) {
                if (PMPConfigPlants.fungusWoollyGomphus > 0) {
                    generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusWoollyGomphus, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusWoollyGomphus), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusWoollyGomphus));
                }
            } else if (PMPConfigPlants.fungusDeathCap > 0) {
                generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusDeathCap, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusDeathCap), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusDeathCap));
            }
        } else if (locationData.getBiomeTemperature() < 1.0f) {
            if (PMPConfigPlants.fungusWeepingMilkCap > 0) {
                generated = PMPGenFungus.generateMushroomCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fungusWeepingMilkCap, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fungusWeepingMilkCap), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fungusWeepingMilkCap));
            }
        } else {
            return false;
        }
        return generated;
    }

    public static boolean generateMushroomCluster(World world, Random random, int x, int y, int z, Block block, int range, int maxPlants) {
        for (int count = 0; count < maxPlants; ++count) {
            int ix = x + random.nextInt(range) - random.nextInt(range);
            int iz = z + random.nextInt(range) - random.nextInt(range);
            int iy = world.func_72825_h(ix, iz);
            Block blockSoil = world.func_147439_a(ix, iy - 1, iz);
            if (!PMPGenBase.canReplaceBlockWithPlant(world, ix, iy, iz) || !PMPGenBase.isSoilBlock(blockSoil) || world.func_72883_k(ix, iy, iz) >= 11) continue;
            PMPGenBase.placePlant(world, random, ix, iy, iz, block, -1);
        }
        return true;
    }
}

