/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import plantmegapack.PlantMegaPack;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.block.PMPBlockCrop;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenVillageCrop
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 0, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.featureVillageCrop) {
            return false;
        }
        int rowDirection = PMPGenVillageCrop.getRowDirection(world, locationData);
        if (rowDirection > 0) {
            PMPGenVillageCrop.spawnCropRow(world, random, locationData, rowDirection);
        }
        return true;
    }

    private static int getRowDirection(World world, PMPSpawnLocation locationData) {
        int north = 0;
        int south = 0;
        int west = 0;
        int east = 0;
        if (world.func_147439_a(locationData.x, locationData.y, locationData.z - 1) == Blocks.field_150464_aj) {
            ++north;
            if (world.func_147439_a(locationData.x, locationData.y, locationData.z - 2) == Blocks.field_150464_aj) {
                ++north;
            }
        }
        if (world.func_147439_a(locationData.x, locationData.y, locationData.z + 1) == Blocks.field_150464_aj) {
            ++south;
            if (world.func_147439_a(locationData.x, locationData.y, locationData.z + 2) == Blocks.field_150464_aj) {
                ++south;
            }
        }
        if (world.func_147439_a(locationData.x - 1, locationData.y, locationData.z) == Blocks.field_150464_aj) {
            ++west;
            if (world.func_147439_a(locationData.x - 2, locationData.y, locationData.z) == Blocks.field_150464_aj) {
                ++west;
            }
        }
        if (world.func_147439_a(locationData.x + 1, locationData.y, locationData.z) == Blocks.field_150464_aj) {
            ++east;
            if (world.func_147439_a(locationData.x + 2, locationData.y, locationData.z) == Blocks.field_150464_aj) {
                ++east;
            }
        }
        if (north > 1 || south > 1) {
            return 1;
        }
        if (west > 1 || east > 1) {
            return 2;
        }
        return 0;
    }

    private static void spawnCropRow(World world, Random random, PMPSpawnLocation locationData, int direction) {
        block5: {
            PMPBlockCrop blockCrop;
            block4: {
                blockCrop = PlantMegaPack.modBlocks.getRandomCropPlant(random);
                world.func_147465_d(locationData.x, locationData.y, locationData.z, (Block)blockCrop, 0, 2);
                if (direction != 1) break block4;
                int x = locationData.x;
                int z = locationData.z - 1;
                while (world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj) {
                    world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 2);
                    --z;
                }
                z = locationData.z + 1;
                while (world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj) {
                    world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 2);
                    ++z;
                }
                break block5;
            }
            if (direction != 2) break block5;
            int x = locationData.x - 1;
            int z = locationData.z;
            while (world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj) {
                world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 2);
                --x;
            }
            x = locationData.x + 1;
            z = locationData.z;
            while (world.func_147439_a(x, locationData.y, z) == Blocks.field_150464_aj) {
                world.func_147465_d(x, locationData.y, z, (Block)blockCrop, 0, 2);
                ++x;
            }
        }
    }
}

