/*
 * Decompiled with CFR 0.152.
 */
package plantmegapack.worldgen.vanilla;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import plantmegapack.bin.PMPBlocks;
import plantmegapack.bin.PMPConfigPlants;
import plantmegapack.bin.PMPConfigWorldgen;
import plantmegapack.bin.PMPSpawnLocation;
import plantmegapack.worldgen.PMPGenBase;

public abstract class PMPGenRiverValley
extends PMPGenBase {
    public static boolean generate(World world, Random random, PMPSpawnLocation locationData) {
        if (PMPConfigWorldgen.debugEnabled) {
            world.func_147465_d(locationData.x, locationData.y, locationData.z, Blocks.field_150325_L, 4, 2);
            return true;
        }
        if (random.nextInt(100) > PMPConfigWorldgen.genRiverValley) {
            return false;
        }
        BiomeGenBase nearDifferentBiome = PMPGenBase.checkForNearDifferentBiome(locationData.biome, world, locationData.x, locationData.y, locationData.z);
        if (nearDifferentBiome != null) {
            locationData.biome = nearDifferentBiome;
        }
        return PMPGenRiverValley.generateByTemperature(world, random, locationData);
    }

    public static boolean generateByTemperature(World world, Random random, PMPSpawnLocation locationData) {
        boolean generated = false;
        if (locationData.getBiomeTemperature() < 0.5f) {
            generated = PMPGenRiverValley.generateColdValley(world, random, locationData);
        } else if (locationData.getBiomeTemperature() <= 0.8f) {
            generated = PMPGenRiverValley.generateWarmValley(world, random, locationData);
        } else if (locationData.getBiomeTemperature() <= 2.0f) {
            generated = PMPGenRiverValley.generateHotValley(world, random, locationData);
        }
        return generated;
    }

    public static boolean generateColdValley(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (locationData.y < 80) {
            if (distribution < 20) {
                if (PMPConfigPlants.fernMaidenhairSpleenwort > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernMaidenhairSpleenwort, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernMaidenhairSpleenwort), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernMaidenhairSpleenwort));
                }
            } else if (distribution < 80) {
                if (PMPConfigPlants.fernSword > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernSword, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernSword), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernSword));
                }
            } else if (distribution < 90) {
                if (PMPConfigPlants.mountainBistort > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.mountainBistort, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.mountainBistort), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.mountainBistort));
                }
            } else if (PMPConfigPlants.flowerStreamsideBluebells > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerStreamsideBluebells, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerStreamsideBluebells), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerStreamsideBluebells));
            }
        } else if (locationData.y < 100) {
            if (distribution < 60) {
                if (PMPConfigPlants.fernWoodsia > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernWoodsia, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernWoodsia), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernWoodsia));
                }
            } else if (distribution < 70) {
                if (PMPConfigPlants.fernSword > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernSword, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernSword), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernSword));
                }
            } else if (distribution < 80) {
                if (PMPConfigPlants.flowerHawkweed > 0) {
                    PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerHawkweed, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerHawkweed), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerHawkweed));
                }
            } else if (distribution < 90) {
                if (PMPConfigPlants.flowerStreamsideBluebells > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerStreamsideBluebells, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerStreamsideBluebells), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerStreamsideBluebells));
                }
            } else if (PMPConfigPlants.berrybushHuckle > 0 && random.nextInt(10) < PMPConfigPlants.berrybushHuckle) {
                PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushHuckle, PMPBlocks.berrybushHuckle.getGrowthStages() - 1);
                PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
            }
        } else if (distribution < 70) {
            if (PMPConfigPlants.fernSword > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernSword, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernSword), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernSword));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.flowerLupine > 0) {
                PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerLupine, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerLupine), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerLupine));
            }
        } else if (PMPConfigPlants.berrybushHuckle > 0 && random.nextInt(10) < PMPConfigPlants.berrybushHuckle) {
            PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushHuckle, PMPBlocks.berrybushHuckle.getGrowthStages() - 1);
            PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
        }
        return true;
    }

    public static boolean generateWarmValley(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (locationData.y < 80) {
            if (distribution < 80 && PMPConfigPlants.fernMaidenhairSpleenwort > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernMaidenhairSpleenwort, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernMaidenhairSpleenwort), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernMaidenhairSpleenwort));
            }
            if (distribution < 90) {
                if (PMPConfigPlants.flowerWoodlandPinkroot > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerWoodlandPinkroot, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerWoodlandPinkroot), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerWoodlandPinkroot));
                }
            } else if (PMPConfigPlants.flowerAchillea > 0) {
                PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerAchillea, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerAchillea), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerAchillea));
            }
        } else if (locationData.y < 100) {
            if (distribution < 70) {
                if (PMPConfigPlants.shrubMeadowsweet > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubMeadowsweet, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubMeadowsweet), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubMeadowsweet));
                }
            } else if (distribution < 90) {
                if (PMPConfigPlants.flowerAchillea > 0) {
                    PMPGenBase.generateRandomMultiFlowerCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.flowerAchillea, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.flowerAchillea), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.flowerAchillea));
                }
            } else if (PMPConfigPlants.berrybushHuckle > 0 && random.nextInt(10) < PMPConfigPlants.berrybushHuckle) {
                PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushHuckle, PMPBlocks.berrybushHuckle.getGrowthStages() - 1);
                PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
            }
        } else {
            if (distribution < 70 && PMPConfigPlants.fernSword > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.fernSword, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.fernSword), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.fernSword));
            }
            if (distribution < 90) {
                if (PMPConfigPlants.shrubWeepingForsythia > 0) {
                    PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubWeepingForsythia, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubWeepingForsythia), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubWeepingForsythia));
                }
            } else if (PMPConfigPlants.berrybushHuckle > 0 && random.nextInt(10) < PMPConfigPlants.berrybushHuckle) {
                PMPGenBase.placePlant(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.berrybushHuckle, PMPBlocks.berrybushHuckle.getGrowthStages() - 1);
                PMPGenBase.surroundPlantWithGrass(world, locationData.x, locationData.y, locationData.z);
            }
        }
        return true;
    }

    public static boolean generateHotValley(World world, Random random, PMPSpawnLocation locationData) {
        int distribution = random.nextInt(100);
        if (distribution < 45) {
            if (PMPConfigPlants.shrubMottlecah > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubMottlecah, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubMottlecah), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubMottlecah));
            }
        } else if (distribution < 90) {
            if (PMPConfigPlants.shrubNinebark > 0) {
                PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.shrubNinebark, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.shrubNinebark), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.shrubNinebark));
            }
        } else if (PMPConfigPlants.savannaTexasTickseed > 0) {
            PMPGenBase.generateRandomPlantCluster(world, random, locationData.x, locationData.y, locationData.z, PMPBlocks.savannaTexasTickseed, PMPGenBase.getClusterSizeFromFreq(PMPConfigPlants.savannaTexasTickseed), PMPGenBase.getClusterFrequency(random, PMPConfigPlants.savannaTexasTickseed));
        }
        return true;
    }
}

