/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.timedmessages;

import java.util.LinkedList;
import java.util.List;
import name.richardson.james.bukkit.utilities.formatters.ColourFormatter;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message
implements Runnable {
    protected final List<String> messages;
    private final Long ticks;
    private final String permission;
    private final Server server;
    private final String worldName;

    public Message(Server server, Long milliseconds, List<String> messages, String permission, String worldName) {
        long seconds = milliseconds / 1000L;
        this.ticks = seconds * 20L;
        this.messages = messages;
        this.permission = permission;
        this.server = server;
        this.worldName = worldName;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getPermission() {
        return this.permission;
    }

    public Long getTicks() {
        return this.ticks;
    }

    @Override
    public void run() {
        String message = this.getNextMessage();
        message = ColourFormatter.replace("&", message);
        String[] parts = message.split("/n");
        LinkedList<Player> players = new LinkedList<Player>();
        World world = null;
        if (this.worldName != null) {
            world = this.server.getWorld(this.worldName);
        }
        for (Player player : this.server.getOnlinePlayers()) {
            if (world != null && player.getLocation().getWorld() != world || this.permission != null && !player.hasPermission(this.permission)) continue;
            players.add(player);
        }
        if (players.isEmpty()) {
            return;
        }
        for (String string : parts) {
            for (Player player : players) {
                player.sendMessage(string);
            }
        }
    }

    protected abstract String getNextMessage();
}

