/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.timedmessages;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import name.richardson.james.bukkit.utilities.persistence.AbstractYAMLStorage;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesConfiguration
extends AbstractYAMLStorage {
    private final List<ConfigurationSection> sections = new LinkedList<ConfigurationSection>();

    public MessagesConfiguration(Plugin plugin) throws IOException {
        super(plugin, "messages.yml");
        this.addExamples();
        this.setConfigurationSections();
    }

    public List<ConfigurationSection> getConfigurationSections() {
        return Collections.unmodifiableList(this.sections);
    }

    private void addExamples() throws IOException {
        if (!this.getConfiguration().isConfigurationSection("messages")) {
            this.getConfiguration().createSection("messages");
            this.getConfiguration().createSection("messages.example");
            ConfigurationSection section = this.getConfiguration().getConfigurationSection("messages.example");
            section.set("mode", (Object)"rotation");
            section.set("delay", (Object)"1m");
            section.set("permission", (Object)"group.default");
            section.set("messages", Arrays.asList("&REDWelcome to our server", "&REDWe hope you enjoy your stay."));
        }
        this.save();
    }

    private void setConfigurationSections() {
        for (String key : this.getConfiguration().getConfigurationSection("messages").getKeys(false)) {
            this.sections.add(this.getConfiguration().getConfigurationSection("messages." + key));
        }
    }
}

