/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.command;

import name.richardson.james.bukkit.utilities.command.Command;
import name.richardson.james.bukkit.utilities.command.CommandArgumentException;
import name.richardson.james.bukkit.utilities.command.CommandPermissionException;
import name.richardson.james.bukkit.utilities.command.CommandUsageException;
import name.richardson.james.bukkit.utilities.command.ConsoleCommand;
import name.richardson.james.bukkit.utilities.localisation.Localisation;
import name.richardson.james.bukkit.utilities.logging.Logger;
import name.richardson.james.bukkit.utilities.permissions.PermissionManager;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public abstract class AbstractCommand
implements Command {
    private final String description;
    private final Localisation localisation;
    private final Logger logger;
    private final String name;
    private Permission permission;
    private final PermissionManager permissions;
    private final String usage;

    public AbstractCommand(Plugin plugin, boolean wildcard) {
        this.localisation = plugin.getLocalisation();
        this.logger = plugin.getCustomLogger();
        this.permissions = plugin.getPermissionManager();
        this.name = this.localisation.getMessage(this, "name");
        this.description = this.localisation.getMessage(this, "description");
        this.usage = this.localisation.getMessage(this, "usage");
        this.registerPermissions(wildcard);
    }

    public String getDescription() {
        return this.description;
    }

    public Localisation getLocalisation() {
        return this.localisation;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public PermissionManager getPermissionManager() {
        return this.permissions;
    }

    public Permission getRootPermission() {
        return this.permission;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        if (!this.getClass().isAnnotationPresent(ConsoleCommand.class) && sender instanceof ConsoleCommandSender) {
            String message = this.localisation.getMessage(AbstractCommand.class, "not-allowed-from-console");
            sender.sendMessage(message);
            return true;
        }
        if (!this.testPermission(sender)) {
            String message = this.localisation.getMessage(AbstractCommand.class, "not-permitted");
            sender.sendMessage(message);
            return true;
        }
        try {
            this.parseArguments(args, sender);
            this.execute(sender);
        }
        catch (CommandArgumentException exception) {
            sender.sendMessage(exception.getMessage());
            if (exception.getHelp() != null) {
                sender.sendMessage(exception.getHelp());
            }
        }
        catch (CommandPermissionException exception) {
            String message = this.localisation.getMessage(AbstractCommand.class, "not-permitted");
            sender.sendMessage(message);
            if (exception.getMessage() != null) {
                sender.sendMessage(exception.getMessage());
            }
            if (this.logger.isDebugging()) {
                sender.sendMessage(this.localisation.getMessage(AbstractCommand.class, "permission-required", exception.getPermission().getName()));
            }
        }
        catch (CommandUsageException exception) {
            sender.sendMessage(ChatColor.RED + exception.getMessage());
        }
        return true;
    }

    public boolean testPermission(CommandSender sender) {
        return this.permissions.hasPlayerPermission((Permissible)sender, this.permission);
    }

    protected void registerPermissions(boolean wildcard) {
        String prefix = this.permissions.getRootPermission().getName().replace("*", "");
        Permission wildcardPermission = null;
        if (wildcard) {
            String wildcardDescription = this.localisation.getMessage(AbstractCommand.class, "wildcard-permission-description", this.name);
            wildcardPermission = new Permission(prefix + this.getName() + ".*", wildcardDescription, PermissionDefault.OP);
            this.permissions.addPermission(wildcardPermission, true);
        }
        Permission base = new Permission(prefix + this.getName(), this.localisation.getMessage(AbstractCommand.class, "permission-description"), PermissionDefault.OP);
        if (wildcardPermission != null) {
            base.addParent(wildcardPermission, true);
        }
        this.permissions.addPermission(base, false);
        this.permission = base;
    }
}

