/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.configuration;

import java.io.IOException;
import name.richardson.james.bukkit.utilities.persistence.AbstractYAMLStorage;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import name.richardson.james.bukkit.utilities.updater.PluginUpdater;

public class PluginConfiguration
extends AbstractYAMLStorage {
    public static String NAME = "config.yml";

    public PluginConfiguration(Plugin plugin) throws IOException {
        super(plugin, "config.yml");
        this.save();
    }

    public PluginUpdater.Branch getAutomaticUpdaterBranch() {
        try {
            return PluginUpdater.Branch.valueOf(this.getConfiguration().getString("automatic-updates.branch", "STABLE"));
        }
        catch (IllegalArgumentException e) {
            return PluginUpdater.Branch.STABLE;
        }
    }

    public PluginUpdater.State getAutomaticUpdaterState() {
        try {
            if (!this.getConfiguration().getBoolean("automatic-updates.enabled", true)) {
                return PluginUpdater.State.OFF;
            }
            return PluginUpdater.State.valueOf(this.getConfiguration().getString("automatic-updates.method", "NOTIFY").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return PluginUpdater.State.NOTIFY;
        }
    }

    public boolean isCollectingStats() {
        return this.getConfiguration().getBoolean("send-anonymous-statistics", true);
    }

    public boolean isDebugging() {
        return this.getConfiguration().getBoolean("debugging");
    }

    public void setAutomaticUpdaterBranch(PluginUpdater.Branch branch) {
        this.getConfiguration().set("automatic-updates.branch", (Object)branch.toString());
    }

    public void setAutomaticUpdaterState(PluginUpdater.State state) {
        switch (state) {
            case NOTIFY: {
                this.getConfiguration().set("automatic-updates.enabled", (Object)true);
                this.getConfiguration().set("automatic-updates.method", (Object)"NOTIFY");
            }
            case OFF: {
                this.getConfiguration().set("automatic-updates.enabled", (Object)false);
            }
        }
    }

    public void setCollectingStats(boolean value) {
        this.getConfiguration().set("send-anonymous-statistics", (Object)value);
    }

    public void setDebugging(boolean value) {
        this.getConfiguration().set("debugging", (Object)value);
    }
}

