/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.localisation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ResourceBundleLoader {
    public static ResourceBundle getBundle(ClassLoader loader, String name) {
        return ResourceBundle.getBundle(name + "-localisation", Locale.getDefault(), loader);
    }

    public static ResourceBundle getBundle(ClassLoader loader, String name, File dataFolder) {
        try {
            String path = dataFolder.getAbsolutePath() + File.separator + "localisation.properties";
            File customBundle = new File(path);
            if (customBundle.exists()) {
                FileInputStream stream = new FileInputStream(customBundle);
                PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
                stream.close();
                return bundle;
            }
            return ResourceBundle.getBundle(name + "-localisation", Locale.getDefault(), loader);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return ResourceBundle.getBundle(name + "-localisation", Locale.getDefault(), loader);
        }
    }
}

