/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.localisation;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import name.richardson.james.bukkit.utilities.formatters.ColourFormatter;
import name.richardson.james.bukkit.utilities.localisation.AbstractLocalisation;

public class ResourceBundleLocalisation
extends AbstractLocalisation {
    private final ResourceBundle[] bundles;

    public ResourceBundleLocalisation(ResourceBundle ... bundles) {
        this.bundles = bundles;
    }

    public String getMessage(Object object, String key) {
        return ColourFormatter.replace(this.getRawMessage(object, key));
    }

    public String getMessage(Object object, String key, Object ... elements) {
        MessageFormat formatter = new MessageFormat(this.getMessage(object, key));
        formatter.setLocale(this.getLocale());
        String message = formatter.format(elements);
        return ColourFormatter.replace(message);
    }

    private String getClassName(Object object) {
        if (object instanceof Class) {
            Class c = (Class)object;
            return c.getSimpleName().toLowerCase();
        }
        return object.getClass().getSimpleName().toLowerCase();
    }

    private String getRawMessage(Object object, String key) {
        key = this.getClassName(object) + "." + key;
        for (ResourceBundle bundle : this.bundles) {
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return key.toUpperCase();
    }
}

