/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import name.richardson.james.bukkit.utilities.persistence.AbstractStorage;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AbstractYAMLStorage
extends AbstractStorage {
    private YamlConfiguration configuration;
    private final File file;

    public AbstractYAMLStorage(Plugin plugin, String fileName) throws IOException {
        super(plugin);
        this.file = new File(plugin.getDataFolder() + File.separator + fileName);
        this.load();
        this.setDefaults(plugin.getResource(fileName));
    }

    public void save(Object ... objects) {
    }

    protected YamlConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void load() {
        this.getLogger().config(AbstractYAMLStorage.class, "loading-configuration", this.getClass().getSimpleName());
        this.getLogger().config(AbstractYAMLStorage.class, "using-path", this.file.getPath());
        this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
    }

    protected void save() {
        try {
            this.getLogger().config(AbstractYAMLStorage.class, "saving-configuration", this.file.getName());
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            this.getLogger().severe(AbstractYAMLStorage.class, "unable-to-save", new Object[0]);
            e.printStackTrace();
        }
    }

    protected void setDefaults(InputStream resource) throws IOException {
        YamlConfiguration defaults = YamlConfiguration.loadConfiguration((InputStream)resource);
        resource.close();
        this.getLogger().config(AbstractYAMLStorage.class, "setting-defaults", new Object[0]);
        this.configuration.setDefaults((Configuration)defaults);
        this.configuration.options().copyDefaults(true);
    }
}

