/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.persistence;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.plugin.java.JavaPlugin;

public class SQLSchema {
    private final String dropDDL;
    private final String generateDDL;
    private final DdlGenerator generator;

    public SQLSchema(JavaPlugin plugin, EbeanServer ebeanServer, boolean validateDDL) {
        SpiEbeanServer server = (SpiEbeanServer)ebeanServer;
        this.generator = server.getDdlGenerator();
        this.dropDDL = this.generator.generateDropDdl();
        this.generateDDL = validateDDL ? this.validateDDL(this.generator.generateCreateDdl()) : this.generator.generateCreateDdl();
    }

    public void runDropDDL() {
        this.generator.runScript(true, this.dropDDL);
    }

    public void runGenerateDDL() {
        this.generator.runScript(false, this.generateDDL);
    }

    private String validateDDL(String schema) {
        BufferedReader scriptReader = new BufferedReader(new StringReader(schema));
        ArrayList<String> scriptLines = new ArrayList<String>();
        HashMap<String, Integer> foundTables = new HashMap<String, Integer>();
        String currentTable = null;
        int tableOffset = 0;
        try {
            String currentLine;
            while ((currentLine = scriptReader.readLine()) != null) {
                String[] alterTableLine;
                currentLine = currentLine.trim();
                scriptLines.add(currentLine.trim());
                if (currentLine.startsWith("create table")) {
                    currentTable = currentLine.split(" ", 4)[2];
                    foundTables.put(currentLine.split(" ", 3)[2], scriptLines.size() - 1);
                    continue;
                }
                if (currentLine.startsWith(";") && currentTable != null && !currentTable.equals("")) {
                    int index = scriptLines.size() - 1;
                    foundTables.put(currentTable, index);
                    String previousLine = (String)scriptLines.get(index - 1);
                    previousLine = previousLine.substring(0, previousLine.length() - 1);
                    scriptLines.set(index - 1, previousLine);
                    scriptLines.set(index, ");");
                    currentTable = null;
                    continue;
                }
                if (!currentLine.startsWith("alter table") || !(alterTableLine = currentLine.split(" ", 4))[3].startsWith("add constraint")) continue;
                String[] addConstraintLine = alterTableLine[3].split(" ", 4);
                if (addConstraintLine[3].startsWith("foreign key")) {
                    int tableLastLine = (Integer)foundTables.get(alterTableLine[2]) + tableOffset;
                    scriptLines.set(tableLastLine - 1, (String)scriptLines.get(tableLastLine - 1) + ",");
                    String constraintLine = String.format("%s %s %s", addConstraintLine[1], addConstraintLine[2], addConstraintLine[3]);
                    scriptLines.add(tableLastLine, constraintLine.substring(0, constraintLine.length() - 1));
                    scriptLines.remove(scriptLines.size() - 1);
                    ++tableOffset;
                    continue;
                }
                throw new RuntimeException("Unsupported action encountered: ALTER TABLE using ADD CONSTRAINT with " + addConstraintLine[3]);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to valid the CreateDDL script!");
        }
        String newScript = "";
        for (String newLine : scriptLines) {
            newScript = newScript + newLine + "\n";
        }
        return newScript;
    }
}

