/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.persistence;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.LogLevel;
import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import name.richardson.james.bukkit.utilities.configuration.DatabaseConfiguration;
import name.richardson.james.bukkit.utilities.persistence.AbstractStorage;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStorage
extends AbstractStorage {
    private final List<Class<?>> classes;
    private ClassLoader classLoader;
    private final DataSourceConfig datasourceConfig;
    private EbeanServer ebeanserver;
    private DdlGenerator generator;
    private boolean rebuild;
    private final ServerConfig serverConfig;

    public SQLStorage(Plugin plugin, DatabaseConfiguration configuration, List<Class<?>> classes) {
        super(plugin);
        this.classes = classes;
        this.serverConfig = configuration.getServerConfig();
        this.serverConfig.setName(plugin.getName());
        this.datasourceConfig = configuration.getDataSourceConfig();
        this.setClassLoader(plugin);
    }

    public List<Class<?>> getClasses() {
        return this.classes;
    }

    public EbeanServer getEbeanServer() {
        return this.ebeanserver;
    }

    public void initalise() {
        if (this.ebeanserver != null) {
            this.getLogger().warning(SQLStorage.class, "already-initalised", new Object[0]);
        }
        this.load();
        if (!this.validate() || this.rebuild) {
            SpiEbeanServer server = (SpiEbeanServer)this.ebeanserver;
            this.generator = server.getDdlGenerator();
            this.drop();
            this.create();
            this.getLogger().info(SQLStorage.class, "rebuilt", new Object[0]);
        }
    }

    @Override
    public void save(Object ... objects) {
    }

    protected void afterDatabaseCreate() {
    }

    protected void beforeDatabaseCreate() {
    }

    protected void beforeDatabaseDrop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create() {
        this.getLogger().debug(SQLStorage.class, "creating-database", new Object[0]);
        this.beforeDatabaseCreate();
        String script = this.generator.generateCreateDdl();
        Level level = Logger.getLogger("").getLevel();
        if (this.datasourceConfig.getDriver().contains("sqlite")) {
            script = this.fixScript(script);
        }
        try {
            Logger.getLogger("").setLevel(Level.OFF);
            this.load();
            this.generator.runScript(false, script);
        }
        finally {
            Logger.getLogger("").setLevel(level);
        }
        this.afterDatabaseCreate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop() {
        this.getLogger().debug(SQLStorage.class, "dropping-database", new Object[0]);
        this.beforeDatabaseDrop();
        Level level = Logger.getLogger("").getLevel();
        try {
            Logger.getLogger("").setLevel(Level.OFF);
            this.generator.runScript(true, this.generator.generateDropDdl());
        }
        finally {
            Logger.getLogger("").setLevel(level);
        }
    }

    private String fixScript(String script) {
        this.getLogger().debug(SQLStorage.class, "fixing-script", new Object[0]);
        BufferedReader scriptReader = new BufferedReader(new StringReader(script));
        ArrayList<String> scriptLines = new ArrayList<String>();
        HashMap<String, Integer> foundTables = new HashMap<String, Integer>();
        String currentTable = null;
        int tableOffset = 0;
        try {
            String currentLine;
            while ((currentLine = scriptReader.readLine()) != null) {
                String[] alterTableLine;
                currentLine = currentLine.trim();
                scriptLines.add(currentLine.trim());
                if (currentLine.startsWith("create table")) {
                    currentTable = currentLine.split(" ", 4)[2];
                    foundTables.put(currentLine.split(" ", 3)[2], scriptLines.size() - 1);
                    continue;
                }
                if (currentLine.startsWith(";") && currentTable != null && !currentTable.equals("")) {
                    int index = scriptLines.size() - 1;
                    foundTables.put(currentTable, index);
                    String previousLine = (String)scriptLines.get(index - 1);
                    previousLine = previousLine.substring(0, previousLine.length() - 1);
                    scriptLines.set(index - 1, previousLine);
                    scriptLines.set(index, ");");
                    currentTable = null;
                    continue;
                }
                if (!currentLine.startsWith("alter table") || !(alterTableLine = currentLine.split(" ", 4))[3].startsWith("add constraint")) continue;
                String[] addConstraintLine = alterTableLine[3].split(" ", 4);
                if (addConstraintLine[3].startsWith("foreign key")) {
                    int tableLastLine = (Integer)foundTables.get(alterTableLine[2]) + tableOffset;
                    scriptLines.set(tableLastLine - 1, (String)scriptLines.get(tableLastLine - 1) + ",");
                    String constraintLine = String.format("%s %s %s", addConstraintLine[1], addConstraintLine[2], addConstraintLine[3]);
                    scriptLines.add(tableLastLine, constraintLine.substring(0, constraintLine.length() - 1));
                    scriptLines.remove(scriptLines.size() - 1);
                    ++tableOffset;
                    continue;
                }
                throw new RuntimeException("Unsupported action encountered: ALTER TABLE using ADD CONSTRAINT with " + addConstraintLine[3]);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to valid the CreateDDL script!");
        }
        String newScript = "";
        for (String newLine : scriptLines) {
            newScript = newScript + newLine + "\n";
        }
        return newScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        this.getLogger().debug(SQLStorage.class, "loading-database", new Object[0]);
        Level level = Logger.getLogger("").getLevel();
        ClassLoader currentClassLoader = null;
        try {
            this.serverConfig.setClasses(this.classes);
            if (this.getLogger().isDebugging()) {
                this.serverConfig.setLoggingToJavaLogger(true);
                this.serverConfig.setLoggingLevel(LogLevel.SQL);
            }
            Logger.getLogger("").setLevel(Level.OFF);
            currentClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.ebeanserver = EbeanServerFactory.create((ServerConfig)this.serverConfig);
        }
        catch (Throwable throwable) {
            Logger.getLogger("").setLevel(level);
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            throw throwable;
        }
        Logger.getLogger("").setLevel(level);
        if (currentClassLoader != null) {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private void setClassLoader(Plugin plugin) {
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getClassLoader", new Class[0]);
            method.setAccessible(true);
            this.classLoader = (ClassLoader)method.invoke((Object)plugin, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to retrieve the ClassLoader of the plugin using Reflection", exception);
        }
    }

    private boolean validate() {
        this.getLogger().debug(SQLStorage.class, "validating-database", new Object[0]);
        for (Class<?> ebean : this.classes) {
            try {
                this.ebeanserver.find(ebean).findRowCount();
            }
            catch (Exception exception) {
                this.getLogger().warning(SQLStorage.class, "validation-failed", exception.getLocalizedMessage());
                return false;
            }
        }
        this.getLogger().debug(SQLStorage.class, "validation-passed", new Object[0]);
        return true;
    }
}

