/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.plugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import name.richardson.james.bukkit.utilities.configuration.PluginConfiguration;
import name.richardson.james.bukkit.utilities.localisation.Localisation;
import name.richardson.james.bukkit.utilities.localisation.ResourceBundleLoader;
import name.richardson.james.bukkit.utilities.localisation.ResourceBundleLocalisation;
import name.richardson.james.bukkit.utilities.logging.ConsoleLogger;
import name.richardson.james.bukkit.utilities.logging.Logger;
import name.richardson.james.bukkit.utilities.metrics.MetricsListener;
import name.richardson.james.bukkit.utilities.permissions.BukkitPermissionManager;
import name.richardson.james.bukkit.utilities.permissions.PermissionManager;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import name.richardson.james.bukkit.utilities.updater.PluginUpdater;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractPlugin
extends JavaPlugin
implements Plugin {
    private PluginConfiguration configuration;
    private final Locale locale = Locale.getDefault();
    private ResourceBundleLocalisation localisation;
    private Logger logger;
    private PermissionManager permissions;

    public Logger getCustomLogger() {
        return this.logger;
    }

    public String getGroupID() {
        return "name.richardson.james.bukkit";
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Localisation getLocalisation() {
        return this.localisation;
    }

    public PermissionManager getPermissionManager() {
        return this.permissions;
    }

    public URL getRepositoryURL() {
        try {
            switch (this.configuration.getAutomaticUpdaterBranch()) {
                case DEVELOPMENT: {
                    return new URL("http://repository.james.richardson.name/snapshots");
                }
            }
            return new URL("http://repository.james.richardson.name/releases");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((org.bukkit.plugin.Plugin)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEnable() {
        block9: {
            try {
                this.loadLocalisation();
                this.setLogging();
                this.setPermissions();
                this.loadConfiguration();
                this.establishPersistence();
                this.registerCommands();
                this.registerListeners();
                this.setupMetrics();
                this.updatePlugin();
            }
            catch (IOException e) {
                this.logger.severe(AbstractPlugin.class, "panic", new Object[0]);
                e.printStackTrace();
                this.setEnabled(false);
            }
            catch (SQLException e) {
                this.logger.severe(AbstractPlugin.class, "panic", new Object[0]);
                e.printStackTrace();
                this.setEnabled(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setEnabled(false);
            }
            finally {
                if (this.isEnabled()) break block9;
                return;
            }
        }
    }

    protected void establishPersistence() throws SQLException {
    }

    protected void loadConfiguration() throws IOException {
        this.configuration = new PluginConfiguration(this);
        this.logger.setDebugging(this.configuration.isDebugging());
    }

    protected void registerCommands() {
    }

    protected void registerListeners() {
    }

    protected void setLogging() {
        this.logger = new ConsoleLogger(this.getLogger(), (Localisation)this.localisation);
        this.logger.setPrefix("[" + this.getName() + "] ");
    }

    protected void setPermissions() {
        this.permissions = new BukkitPermissionManager(this);
        String node = this.getDescription().getName().toLowerCase() + ".*";
        String description = this.localisation.getMessage(AbstractPlugin.class, "permission-description", this.getDescription().getName());
        Permission permission = new Permission(node, description, PermissionDefault.OP);
        this.permissions.addPermission(permission, false);
        this.permissions.setRootPermission(permission);
    }

    protected void setupMetrics() throws IOException {
        new MetricsListener(this);
    }

    private void loadLocalisation() throws IOException {
        ResourceBundle[] bundles = new ResourceBundle[]{ResourceBundleLoader.getBundle(this.getClassLoader(), "bukkitutilities"), ResourceBundleLoader.getBundle(this.getClassLoader(), this.getName().toLowerCase(), this.getDataFolder())};
        this.localisation = new ResourceBundleLocalisation(bundles);
    }

    private void updatePlugin() {
        if (this.configuration.getAutomaticUpdaterState() != PluginUpdater.State.OFF) {
            new PluginUpdater(this, this.configuration.getAutomaticUpdaterState(), this.configuration.getAutomaticUpdaterBranch());
        }
    }
}

