/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.timedmessages;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import name.richardson.james.bukkit.timedmessages.Message;
import name.richardson.james.bukkit.timedmessages.MessagesConfiguration;
import name.richardson.james.bukkit.timedmessages.MetricsListener;
import name.richardson.james.bukkit.timedmessages.management.ReloadCommand;
import name.richardson.james.bukkit.timedmessages.management.StartCommand;
import name.richardson.james.bukkit.timedmessages.management.StatusCommand;
import name.richardson.james.bukkit.timedmessages.management.StopCommand;
import name.richardson.james.bukkit.timedmessages.random.RandomMessage;
import name.richardson.james.bukkit.timedmessages.rotation.RotatingMessage;
import name.richardson.james.bukkit.utilities.command.CommandManager;
import name.richardson.james.bukkit.utilities.formatters.TimeFormatter;
import name.richardson.james.bukkit.utilities.plugin.AbstractPlugin;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class TimedMessages
extends AbstractPlugin {
    public static final long START_DELAY = 5L;
    private final Set<Message> timers = new HashSet<Message>();
    private List<ConfigurationSection> messages;
    private boolean timersStarted = false;

    public String getArtifactID() {
        return "timed-messages";
    }

    public String getGroupID() {
        return "name.richardson.james.bukkit";
    }

    public int getTimerCount() {
        return this.timers.size();
    }

    public int getMessageCount() {
        int i = 0;
        for (Message message : this.timers) {
            i = message.getMessages().size();
        }
        return i;
    }

    public boolean isTimersStarted() {
        return this.timersStarted;
    }

    protected void loadConfiguration() throws IOException {
        super.loadConfiguration();
        MessagesConfiguration configuration = new MessagesConfiguration(this);
        this.messages = configuration.getConfigurationSections();
        this.startTimers(5L);
    }

    public void onDisable() {
        this.stopTimers();
    }

    public void startTimers(long startDelay) {
        if (this.timersStarted) {
            this.stopTimers();
        }
        this.timersStarted = true;
        startDelay *= 20L;
        for (ConfigurationSection section : this.messages) {
            Long milliseconds = TimeFormatter.parseTime(section.getString("delay", "5m"));
            List messages = section.getStringList("messages");
            String permission = section.getString("permission");
            String mode = section.getString("mode", "rotation");
            String worldName = section.getString("world");
            Message task = mode.equalsIgnoreCase("rotation") ? new RotatingMessage(this.getServer(), milliseconds, messages, permission, worldName) : new RandomMessage(this.getServer(), milliseconds, messages, permission, worldName);
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)task, startDelay, task.getTicks().longValue());
            this.timers.add(task);
        }
    }

    public void stopTimers() {
        this.timersStarted = false;
        this.timers.clear();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public void reloadConfiguration() throws IOException {
        this.loadConfiguration();
        this.startTimers(5L);
    }

    protected void setupMetrics() throws IOException {
        new MetricsListener(this);
    }

    protected void registerCommands() {
        CommandManager commandManager = new CommandManager(this);
        this.getCommand("tm").setExecutor((CommandExecutor)commandManager);
        commandManager.addCommand(new ReloadCommand(this));
        commandManager.addCommand(new StartCommand(this));
        commandManager.addCommand(new StatusCommand(this));
        commandManager.addCommand(new StopCommand(this));
    }
}

