/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.command;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import name.richardson.james.bukkit.utilities.command.Command;
import name.richardson.james.bukkit.utilities.localisation.Localisation;
import name.richardson.james.bukkit.utilities.logging.Logger;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandManager
implements CommandExecutor {
    public static final ChatColor OPTIONAL_ARGUMENT_COLOUR = ChatColor.GREEN;
    public static final ChatColor REQUIRED_ARGUMENT_COLOUR = ChatColor.YELLOW;
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private final String helpCommand;
    private final Localisation localisation;
    private final Logger logger;
    private final String pluginDescription;
    private final String pluginName;

    public CommandManager(Plugin plugin) {
        this.localisation = plugin.getLocalisation();
        this.logger = plugin.getCustomLogger();
        this.pluginName = plugin.getDescription().getFullName();
        this.pluginDescription = this.localisation.getMessage(plugin, "description");
        this.helpCommand = this.localisation.getMessage(this, "help-command");
    }

    public void addCommand(Command command) {
        this.logger.debug(this, "adding-command", command.getClass().getSimpleName());
        this.commands.put(command.getName(), command);
    }

    public void addCommand(Command command, String name) {
        this.logger.debug(this, "adding-command", command.getClass().getSimpleName());
        this.commands.put(name, command);
    }

    public Map<String, Command> getCommands() {
        return Collections.unmodifiableMap(this.commands);
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ChatColor.LIGHT_PURPLE + this.pluginName);
            sender.sendMessage(ChatColor.AQUA + this.pluginDescription);
            sender.sendMessage(this.localisation.getMessage(this, "help-usage", cmd.getName(), this.helpCommand));
            for (Command command : this.commands.values()) {
                if (!command.testPermission(sender)) continue;
                sender.sendMessage(this.getCommandHelpEntry(label, command));
            }
            return true;
        }
        if (args.length != 0 && this.commands.containsKey(args[0].toLowerCase())) {
            Command command = this.commands.get(args[0]);
            String[] arguments = this.prepareArguments(args, args[0]);
            command.onCommand(sender, cmd, null, arguments);
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase(this.helpCommand)) {
            if (this.commands.containsKey(args[1]) && this.commands.get(args[1]).testPermission(sender)) {
                Command command = this.commands.get(args[1]);
                sender.sendMessage(ChatColor.LIGHT_PURPLE + command.getDescription());
                sender.sendMessage(this.getCommandHelpEntry(label, command));
            } else {
                sender.sendMessage(this.localisation.getMessage(this, "invalid-command"));
                sender.sendMessage(this.localisation.getMessage(this, "list-commands", cmd.getName()));
            }
            return true;
        }
        sender.sendMessage(this.localisation.getMessage(this, "invalid-command"));
        sender.sendMessage(this.localisation.getMessage(this, "list-commands", cmd.getName()));
        return true;
    }

    private String getCommandHelpEntry(String label, Command command) {
        String usage = command.getUsage();
        usage = usage.replaceAll("\\<", REQUIRED_ARGUMENT_COLOUR + "<");
        usage = usage.replaceAll("\\[", OPTIONAL_ARGUMENT_COLOUR + "[");
        return this.localisation.getMessage(this, "help-entry", label, REQUIRED_ARGUMENT_COLOUR + command.getName(), usage);
    }

    private String[] prepareArguments(String[] args, String name) {
        if (args[0].equalsIgnoreCase(name)) {
            String[] arguments = new String[args.length - 1];
            System.arraycopy(args, 1, arguments, 0, args.length - 1);
            return arguments;
        }
        return args;
    }
}

