/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.formatters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeFormatter {
    public static final long SECONDS = 60L;
    public static final long MINUTES = 60L;
    public static final long HOURS = 24L;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;

    public static String millisToLongDHMS(long duration) {
        StringBuffer res = new StringBuffer();
        long temp = 0L;
        if (duration >= 1000L) {
            temp = duration / 86400000L;
            if (temp > 0L) {
                res.append(temp).append(" day").append(temp > 1L ? "s" : "").append((duration -= temp * 86400000L) >= 60000L ? ", " : "");
            }
            if ((temp = duration / 3600000L) > 0L) {
                res.append(temp).append(" hour").append(temp > 1L ? "s" : "").append((duration -= temp * 3600000L) >= 60000L ? ", " : "");
            }
            if ((temp = duration / 60000L) > 0L) {
                duration -= temp * 60000L;
                res.append(temp).append(" minute").append(temp > 1L ? "s" : "");
            }
            if (!res.toString().equals("") && duration >= 1000L) {
                res.append(" and ");
            }
            if ((temp = duration / 1000L) > 0L) {
                res.append(temp).append(" second").append(temp > 1L ? "s" : "");
            }
            return res.toString();
        }
        return "0 second";
    }

    public static Long parseTime(String timeString) {
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        Pattern p = Pattern.compile("\\d+[a-z]{1}");
        Matcher m = p.matcher(timeString);
        boolean result = m.find();
        while (result) {
            String argument = m.group();
            if (argument.endsWith("w")) {
                weeks = Integer.parseInt(argument.substring(0, argument.length() - 1));
            } else if (argument.endsWith("d")) {
                days = Integer.parseInt(argument.substring(0, argument.length() - 1));
            } else if (argument.endsWith("h")) {
                hours = Integer.parseInt(argument.substring(0, argument.length() - 1));
            } else if (argument.endsWith("m")) {
                minutes = Integer.parseInt(argument.substring(0, argument.length() - 1));
            } else if (argument.endsWith("s")) {
                seconds = Integer.parseInt(argument.substring(0, argument.length() - 1));
            } else {
                throw new NumberFormatException("Invalid time format");
            }
            result = m.find();
        }
        long time = seconds;
        time += (long)(minutes * 60);
        time += (long)(hours * 3600);
        time += (long)(days * 86400);
        time += (long)(weeks * 604800);
        return time *= 1000L;
    }
}

