/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import name.richardson.james.bukkit.utilities.localisation.Localisation;
import name.richardson.james.bukkit.utilities.logging.AbstractLogger;
import name.richardson.james.bukkit.utilities.logging.Logger;
import org.bukkit.ChatColor;

public final class ConsoleLogger
extends AbstractLogger {
    private final Localisation localisation;
    private final java.util.logging.Logger logger;

    public ConsoleLogger(java.util.logging.Logger logger, Localisation localisation) {
        this.logger = logger;
        this.logger.setLevel(Logger.DEFAULT_LEVEL);
        this.localisation = localisation;
    }

    public ConsoleLogger(Object owner, Localisation localisation) {
        this.logger = java.util.logging.Logger.getLogger(owner.getClass().getName());
        this.logger.setLevel(Logger.DEFAULT_LEVEL);
        this.localisation = localisation;
    }

    public void config(Object object, String message, Object ... elements) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        String formattedMessage = this.localisation.getMessage(object, message, elements);
        this.logger.config(ChatColor.stripColor((String)formattedMessage));
    }

    public void debug(Object object, String message, Object ... elements) {
        if (!this.logger.isLoggable(Level.ALL)) {
            return;
        }
        String formattedMessage = this.getDebugPrefix(object) + this.localisation.getMessage(object, message, elements);
        this.logger.fine(ChatColor.stripColor((String)formattedMessage));
    }

    public String getName() {
        return this.logger.getName();
    }

    public void info(Object object, String message, Object ... elements) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        String formattedMessage = this.localisation.getMessage(object, message, elements);
        this.logger.info(ChatColor.stripColor((String)formattedMessage));
    }

    public boolean isDebugging() {
        return this.logger.isLoggable(Logger.DEBUG_LEVEL);
    }

    public void setDebugging(boolean debugging) {
        if (debugging) {
            this.logger.setLevel(Logger.DEBUG_LEVEL);
            for (Handler handler : this.logger.getParent().getHandlers()) {
                handler.setLevel(Level.ALL);
            }
        } else {
            this.logger.setLevel(Logger.DEFAULT_LEVEL);
        }
    }

    public void severe(Object object, String message, Object ... elements) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        String formattedMessage = this.localisation.getMessage(object, message, elements);
        this.logger.severe(ChatColor.stripColor((String)formattedMessage));
    }

    public void warning(Object object, String message, Object ... elements) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        String formattedMessage = this.localisation.getMessage(object, message, elements);
        this.logger.warning(ChatColor.stripColor((String)formattedMessage));
    }

    private String getDebugPrefix(Object object) {
        if (object instanceof Class) {
            Class c = (Class)object;
            return "<" + c.getSimpleName() + "> ";
        }
        return "<" + object.getClass().getSimpleName() + "> ";
    }
}

