/*
 * Decompiled with CFR 0.152.
 */
package name.richardson.james.bukkit.utilities.permissions;

import name.richardson.james.bukkit.utilities.permissions.AbstractPermissionManager;
import name.richardson.james.bukkit.utilities.plugin.Plugin;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;

public class BukkitPermissionManager
extends AbstractPermissionManager {
    private final PluginManager pluginManager = Bukkit.getServer().getPluginManager();
    private Permission rootPermission;

    public BukkitPermissionManager(Plugin plugin) {
        super(plugin);
    }

    public void addPermission(Permission permission, boolean attachToRoot) {
        if (attachToRoot) {
            permission.addParent(this.getRootPermission(), true);
        }
        if (this.pluginManager.getPermission(permission.getName()) == null) {
            this.pluginManager.addPermission(permission);
            this.getLogger().debug(this, "permission-added", permission.getName(), permission.getDefault());
        } else {
            this.getLogger().warning(this, "permission-already-exists", permission.getName());
        }
    }

    public Permission getPermission(String name) {
        return this.pluginManager.getPermission(name);
    }

    public Permission getRootPermission() {
        return this.rootPermission;
    }

    public boolean hasPlayerPermission(Permissible player, Permission permission) {
        this.getLogger().debug(this, "checking-permission", permission.getName());
        return player.hasPermission(permission);
    }

    public boolean hasPlayerPermission(Permissible player, String name) {
        this.getLogger().debug(this, "checking-permission", name);
        return player.hasPermission(name);
    }

    public void setRootPermission(Permission permission) {
        if (this.rootPermission != null) {
            this.getLogger().warning(this, "root-permission-already-set", this.rootPermission.getName());
        } else {
            this.rootPermission = permission;
            this.getLogger().debug(this, "root-permission-added", permission.getName(), permission.getDefault());
        }
    }
}

